/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.osgitools.BundleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenDependencyInjector {
    private static final String P2_GROUPID_PREFIX = "p2.";
    private static final List<Dependency> NO_DEPENDENCIES = Collections.emptyList();
    private final BundleReader bundleReader;
    private final Logger logger;
    private final MavenProject project;

    public static void injectMavenDependencies(MavenProject project, DependencyArtifacts dependencies, BundleReader bundleReader, Logger logger) {
        MavenDependencyInjector generator = new MavenDependencyInjector(project, bundleReader, logger);
        for (ArtifactDescriptor artifact : dependencies.getArtifacts()) {
            generator.addDependency(artifact);
        }
    }

    MavenDependencyInjector(MavenProject project, BundleReader bundleReader, Logger logger) {
        this.project = project;
        this.bundleReader = bundleReader;
        this.logger = logger;
    }

    void addDependency(ArtifactDescriptor artifact) {
        ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
        if (artifact.getMavenProject() != null) {
            dependencyList.addAll(this.newProjectDependencies(artifact));
        } else {
            dependencyList.addAll(this.newExternalDependencies(artifact));
        }
        Model model = this.project.getModel();
        for (Dependency dependency : dependencyList) {
            model.addDependency(dependency);
        }
    }

    private List<Dependency> newExternalDependencies(ArtifactDescriptor artifact) {
        File location = artifact.getLocation();
        if (!location.isFile() || !location.canRead()) {
            this.logger.debug("Dependency at location " + location + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins");
            return NO_DEPENDENCIES;
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        if ("eclipse-plugin".equals(artifact.getKey().getType())) {
            for (String classpathElement : this.getClasspathElements(location)) {
                if (".".equals(classpathElement)) {
                    result.add(this.createSystemScopeDependency(artifact.getKey(), location));
                    continue;
                }
                File nestedJarOrDir = this.bundleReader.getEntry(location, classpathElement);
                if (nestedJarOrDir == null) continue;
                if (nestedJarOrDir.isFile()) {
                    Dependency nestedJarDependency = this.createSystemScopeDependency(artifact.getKey(), nestedJarOrDir);
                    nestedJarDependency.setClassifier(classpathElement);
                    result.add(nestedJarDependency);
                    continue;
                }
                if (!nestedJarOrDir.isDirectory()) continue;
                this.logger.debug("Dependency from " + this.project.getBasedir() + " to nested directory classpath entry " + nestedJarOrDir + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins");
            }
        } else {
            result.add(this.createSystemScopeDependency(artifact.getKey(), location));
        }
        return result;
    }

    private String[] getClasspathElements(File bundleLocation) {
        return this.bundleReader.loadManifest(bundleLocation).getBundleClasspath();
    }

    private Dependency createSystemScopeDependency(ArtifactKey artifactKey, File location) {
        return this.createSystemScopeDependency(artifactKey, P2_GROUPID_PREFIX + artifactKey.getType(), location);
    }

    private Dependency createSystemScopeDependency(ArtifactKey artifactKey, String groupId, File location) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactKey.getId());
        dependency.setVersion(artifactKey.getVersion());
        dependency.setScope("system");
        dependency.setSystemPath(location.getAbsolutePath());
        return dependency;
    }

    private List<Dependency> newProjectDependencies(ArtifactDescriptor artifact) {
        ReactorProject dependentMavenProjectProxy = artifact.getMavenProject();
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        if (!artifact.getMavenProject().sameProject((Object)this.project)) {
            result.add(this.createProvidedScopeDependency(dependentMavenProjectProxy));
        }
        if ("eclipse-plugin".equals(dependentMavenProjectProxy.getPackaging())) {
            for (String classpathElement : this.getClasspathElements(dependentMavenProjectProxy.getBasedir())) {
                if (".".equals(classpathElement)) continue;
                File jar = new File(dependentMavenProjectProxy.getBasedir(), classpathElement);
                if (jar.isFile()) {
                    Dependency systemScopeDependency = this.createSystemScopeDependency(artifact.getKey(), artifact.getMavenProject().getGroupId(), jar);
                    systemScopeDependency.setClassifier(classpathElement);
                    result.add(systemScopeDependency);
                    continue;
                }
                this.logger.debug("Dependency from " + this.project.getBasedir() + " to nested classpath entry " + jar.getAbsolutePath() + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins");
            }
        }
        return result;
    }

    private Dependency createProvidedScopeDependency(ReactorProject dependentReactorProject) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(dependentReactorProject.getArtifactId());
        dependency.setGroupId(dependentReactorProject.getGroupId());
        dependency.setVersion(dependentReactorProject.getVersion());
        dependency.setType(dependentReactorProject.getPackaging());
        dependency.setScope("provided");
        return dependency;
    }
}

