/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.core.ee.EEVersion;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardExecutionEnvironment
implements Comparable<StandardExecutionEnvironment>,
ExecutionEnvironment {
    private static final Map<String, String> TARGET_ALIASES;
    private String profileName;
    private String compilerSourceLevel;
    private String compilerTargetLevel;
    private Set<String> systemPackages;
    private EEVersion eeVersion;
    private Properties profileProperties;

    StandardExecutionEnvironment(Properties profileProperties) {
        this.profileName = profileProperties.getProperty("osgi.java.profile.name");
        this.compilerSourceLevel = profileProperties.getProperty("org.eclipse.jdt.core.compiler.source");
        this.compilerTargetLevel = profileProperties.getProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
        this.systemPackages = new LinkedHashSet<String>(Arrays.asList(profileProperties.getProperty("org.osgi.framework.system.packages").split(",")));
        this.eeVersion = this.parseEEVersion(profileProperties.getProperty("org.osgi.framework.system.capabilities"));
        this.profileProperties = new Properties();
        this.profileProperties.putAll((Map<?, ?>)profileProperties);
    }

    private EEVersion parseEEVersion(String systemCaps) {
        ArrayList<EEVersion> eeVersions = new ArrayList<EEVersion>();
        try {
            ManifestElement[] systemCapValues = ManifestElement.parseHeader((String)"org.osgi.framework.system.capabilities", (String)systemCaps);
            for (int i = 0; i < systemCapValues.length; ++i) {
                Version version;
                String singleVersion = systemCapValues[i].getAttribute("version:Version");
                if (singleVersion != null) {
                    version = Version.parseVersion((String)singleVersion);
                } else {
                    String[] versions = systemCapValues[i].getAttribute("version:List<Version>").split(",");
                    ArrayList<Version> osgiVersions = new ArrayList<Version>(versions.length);
                    for (String currentVersion : versions) {
                        osgiVersions.add(Version.parseVersion((String)currentVersion));
                    }
                    version = (Version)Collections.max(osgiVersions);
                }
                String execEnv = systemCapValues[i].getAttribute("osgi.ee");
                EEVersion.EEType eeType = EEVersion.EEType.fromName(execEnv);
                if (eeType == null) continue;
                eeVersions.add(new EEVersion(version, eeType));
            }
            return (EEVersion)Collections.max(eeVersions);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getCompilerSourceLevelDefault() {
        return this.compilerSourceLevel;
    }

    public String getCompilerTargetLevelDefault() {
        return this.compilerTargetLevel;
    }

    public String toString() {
        return "OSGi profile '" + this.getProfileName() + "' { source level: " + this.compilerSourceLevel + ", target level: " + this.compilerTargetLevel + "}";
    }

    public Set<String> getSystemPackages() {
        return this.systemPackages;
    }

    @Override
    public int compareTo(StandardExecutionEnvironment otherEnv) {
        return this.eeVersion.compareTo(otherEnv.eeVersion);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compilerSourceLevel == null ? 0 : this.compilerSourceLevel.hashCode());
        result = 31 * result + (this.compilerTargetLevel == null ? 0 : this.compilerTargetLevel.hashCode());
        result = 31 * result + (this.eeVersion == null ? 0 : this.eeVersion.hashCode());
        result = 31 * result + (this.profileName == null ? 0 : this.profileName.hashCode());
        result = 31 * result + (this.profileProperties == null ? 0 : this.profileProperties.hashCode());
        result = 31 * result + (this.systemPackages == null ? 0 : this.systemPackages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardExecutionEnvironment)) {
            return false;
        }
        StandardExecutionEnvironment other = (StandardExecutionEnvironment)obj;
        if (this.compilerSourceLevel == null ? other.compilerSourceLevel != null : !this.compilerSourceLevel.equals(other.compilerSourceLevel)) {
            return false;
        }
        if (this.compilerTargetLevel == null ? other.compilerTargetLevel != null : !this.compilerTargetLevel.equals(other.compilerTargetLevel)) {
            return false;
        }
        if (this.eeVersion == null ? other.eeVersion != null : !this.eeVersion.equals(other.eeVersion)) {
            return false;
        }
        if (this.profileName == null ? other.profileName != null : !this.profileName.equals(other.profileName)) {
            return false;
        }
        if (this.profileProperties == null ? other.profileProperties != null : !this.profileProperties.equals(other.profileProperties)) {
            return false;
        }
        return !(this.systemPackages == null ? other.systemPackages != null : !this.systemPackages.equals(other.systemPackages));
    }

    public Properties getProfileProperties() {
        return this.profileProperties;
    }

    public boolean isCompatibleCompilerTargetLevel(String target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerTargetLevel == null) {
            return true;
        }
        try {
            Version thisTargetVersion = StandardExecutionEnvironment.toTargetVersion(this.compilerTargetLevel);
            Version targetVersion = StandardExecutionEnvironment.toTargetVersion(target);
            return thisTargetVersion.compareTo(targetVersion) >= 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Version toTargetVersion(String target) {
        String targetAlias = TARGET_ALIASES.get(target.trim().toLowerCase());
        if (targetAlias != null) {
            target = targetAlias;
        }
        return Version.parseVersion((String)target);
    }

    static {
        HashMap<String, String> targetAliases = new HashMap<String, String>();
        targetAliases.put("jsr14", "1.4");
        targetAliases.put("5", "1.5");
        targetAliases.put("5.0", "1.5");
        targetAliases.put("6", "1.6");
        targetAliases.put("6.0", "1.6");
        targetAliases.put("7", "1.7");
        targetAliases.put("7.0", "1.7");
        targetAliases.put("8", "1.8");
        targetAliases.put("8.0", "1.8");
        TARGET_ALIASES = Collections.unmodifiableMap(targetAliases);
    }
}

