/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.UnknownEnvironmentException;
import org.osgi.framework.BundleActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionEnvironmentUtils {
    private static Map<String, StandardExecutionEnvironment> executionEnvironmentsMap = ExecutionEnvironmentUtils.fillEnvironmentsMap();

    private static Map<String, StandardExecutionEnvironment> fillEnvironmentsMap() {
        Properties listProps = ExecutionEnvironmentUtils.readProperties(ExecutionEnvironmentUtils.findInSystemBundle("profile.list"));
        String[] profileFiles = listProps.getProperty("java.profiles").split(",");
        HashMap<String, StandardExecutionEnvironment> envMap = new HashMap<String, StandardExecutionEnvironment>();
        Pattern compactProfilePattern = Pattern.compile("JavaSE/compact\\d-1.8");
        for (String profileFile : profileFiles) {
            Properties props = ExecutionEnvironmentUtils.readProperties(ExecutionEnvironmentUtils.findInSystemBundle(profileFile.trim()));
            String profileName = props.getProperty("osgi.java.profile.name").trim();
            if (compactProfilePattern.matcher(profileName).matches()) continue;
            envMap.put(profileName, new StandardExecutionEnvironment(props));
        }
        return envMap;
    }

    private static Properties readProperties(URL url) {
        Properties listProps = new Properties();
        InputStream stream = null;
        try {
            stream = url.openStream();
            listProps.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return listProps;
    }

    public static StandardExecutionEnvironment getExecutionEnvironment(String profileName) throws UnknownEnvironmentException {
        StandardExecutionEnvironment executionEnvironment = executionEnvironmentsMap.get(profileName);
        if (executionEnvironment == null) {
            throw new UnknownEnvironmentException(profileName);
        }
        return executionEnvironment;
    }

    public static void applyProfileProperties(Properties properties, Properties profileProps) {
        String systemCapabilities;
        String ee;
        String systemExports = properties.getProperty("org.osgi.framework.system.packages");
        if (systemExports == null && (systemExports = profileProps.getProperty("org.osgi.framework.system.packages")) != null) {
            properties.put("org.osgi.framework.system.packages", systemExports);
        }
        String type = properties.getProperty("osgi.java.profile.bootdelegation");
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                properties.remove("org.osgi.framework.bootdelegation");
            } else {
                properties.put("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            properties.remove("org.osgi.framework.bootdelegation");
        }
        if (properties.getProperty("org.osgi.framework.executionenvironment") == null && (ee = profileProps.getProperty("org.osgi.framework.executionenvironment", profileProps.getProperty("osgi.java.profile.name"))) != null) {
            properties.put("org.osgi.framework.executionenvironment", ee);
        }
        if (properties.getProperty("org.osgi.framework.system.capabilities") == null && (systemCapabilities = profileProps.getProperty("org.osgi.framework.system.capabilities")) != null) {
            properties.put("org.osgi.framework.system.capabilities", systemCapabilities);
        }
    }

    private static URL findInSystemBundle(String entry) {
        ClassLoader loader = BundleActivator.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
    }
}

