/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.AccessModifierDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.EnumTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InterfaceTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.VisibilityModifier;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AbstractTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AnnotationVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.ClassSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.DependentTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.FieldVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassVisitor
extends org.objectweb.asm.ClassVisitor {
    private TypeCache.CachedType<ClassFileDescriptor> cachedType;
    private VisitorHelper visitorHelper;

    public ClassVisitor(VisitorHelper visitorHelper) {
        super(327680);
        this.visitorHelper = visitorHelper;
    }

    public ClassFileDescriptor getTypeDescriptor() {
        return this.cachedType.getTypeDescriptor();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Class<? extends ClassFileDescriptor> javaType = this.getJavaType(access);
        this.cachedType = this.visitorHelper.createType(SignatureHelper.getObjectType(name), javaType);
        if (this.hasFlag(access, 1024) && !this.hasFlag(access, 512)) {
            this.cachedType.getTypeDescriptor().setAbstract(Boolean.TRUE);
        }
        this.setModifiers(access, this.cachedType.getTypeDescriptor());
        if (signature == null) {
            if (superName != null) {
                Object superClassType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(superName), this.cachedType).getTypeDescriptor();
                this.cachedType.getTypeDescriptor().setSuperClass((TypeDescriptor)superClassType);
            }
            for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
                Object interfaceType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(interfaces[i]), this.cachedType).getTypeDescriptor();
                this.cachedType.getTypeDescriptor().getInterfaces().add((TypeDescriptor)interfaceType);
            }
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new ClassSignatureVisitor(this.cachedType, this.visitorHelper));
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        final FieldDescriptor fieldDescriptor = this.visitorHelper.getFieldDescriptor(this.cachedType, SignatureHelper.getFieldSignature(name, desc));
        fieldDescriptor.setName(name);
        fieldDescriptor.setVolatile(this.hasFlag(access, 64));
        fieldDescriptor.setTransient(this.hasFlag(access, 128));
        this.setModifiers(access, fieldDescriptor);
        if (signature == null) {
            Object type = this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.cachedType).getTypeDescriptor();
            fieldDescriptor.setType((TypeDescriptor)type);
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new AbstractTypeSignatureVisitor<FieldDescriptor>(this.cachedType, this.visitorHelper){

                public SignatureVisitor visitArrayType() {
                    return new DependentTypeSignatureVisitor(ClassVisitor.this.cachedType, ClassVisitor.this.visitorHelper);
                }

                public SignatureVisitor visitTypeArgument(char wildcard) {
                    return new DependentTypeSignatureVisitor(ClassVisitor.this.cachedType, ClassVisitor.this.visitorHelper);
                }

                public SignatureVisitor visitSuperclass() {
                    return this;
                }

                @Override
                public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                    fieldDescriptor.setType(resolvedTypeDescriptor);
                }
            });
        }
        if (value instanceof Type) {
            this.visitorHelper.resolveType(SignatureHelper.getType((Type)value), this.cachedType);
        }
        return new FieldVisitor(this.cachedType, fieldDescriptor, this.visitorHelper);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDescriptor methodDescriptor = this.visitorHelper.getMethodDescriptor(this.cachedType, SignatureHelper.getMethodSignature(name, desc));
        methodDescriptor.setName(name);
        this.setModifiers(access, methodDescriptor);
        if (this.hasFlag(access, 1024)) {
            methodDescriptor.setAbstract(Boolean.TRUE);
        }
        if (this.hasFlag(access, 256)) {
            methodDescriptor.setNative(Boolean.TRUE);
        }
        if (signature == null) {
            String returnType = SignatureHelper.getType(Type.getReturnType((String)desc));
            methodDescriptor.setReturns((TypeDescriptor)this.visitorHelper.resolveType(returnType, this.cachedType).getTypeDescriptor());
            Type[] types = Type.getArgumentTypes((String)desc);
            for (int i = 0; i < types.length; ++i) {
                ParameterDescriptor parameterDescriptor = this.visitorHelper.addParameterDescriptor(methodDescriptor, i);
                String parameterType = SignatureHelper.getType(types[i]);
                parameterDescriptor.setType((TypeDescriptor)this.visitorHelper.resolveType(parameterType, this.cachedType).getTypeDescriptor());
            }
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new MethodSignatureVisitor(this.cachedType, methodDescriptor, this.visitorHelper));
        }
        for (int i = 0; exceptions != null && i < exceptions.length; ++i) {
            Object exceptionType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(exceptions[i]), this.cachedType).getTypeDescriptor();
            methodDescriptor.getDeclaredThrowables().add((TypeDescriptor)exceptionType);
        }
        return new MethodVisitor(this.cachedType, methodDescriptor, this.visitorHelper);
    }

    private void setModifiers(int access, AccessModifierDescriptor descriptor) {
        VisibilityModifier visibility = this.getVisibility(access);
        descriptor.setVisibility(visibility.getValue());
        if (this.hasFlag(access, 4096)) {
            descriptor.setSynthetic(Boolean.TRUE);
        }
        if (this.hasFlag(access, 16)) {
            descriptor.setFinal(Boolean.TRUE);
        }
        if (this.hasFlag(access, 8)) {
            descriptor.setStatic(Boolean.TRUE);
        }
    }

    public void visitSource(String source, String debug) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.addInnerClass(this.cachedType.getTypeDescriptor(), (TypeDescriptor)this.visitorHelper.resolveType(SignatureHelper.getObjectType(name), this.cachedType).getTypeDescriptor());
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.addInnerClass((TypeDescriptor)this.visitorHelper.resolveType(SignatureHelper.getObjectType(owner), this.cachedType).getTypeDescriptor(), this.cachedType.getTypeDescriptor());
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationValueDescriptor annotationDescriptor = this.visitorHelper.addAnnotation(this.cachedType, this.cachedType.getTypeDescriptor(), SignatureHelper.getType(desc));
        return new AnnotationVisitor(this.cachedType, annotationDescriptor, this.visitorHelper);
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitEnd() {
    }

    private boolean hasFlag(int value, int flag) {
        return (value & flag) == flag;
    }

    private VisibilityModifier getVisibility(int flags) {
        if (this.hasFlag(flags, 2)) {
            return VisibilityModifier.PRIVATE;
        }
        if (this.hasFlag(flags, 4)) {
            return VisibilityModifier.PROTECTED;
        }
        if (this.hasFlag(flags, 1)) {
            return VisibilityModifier.PUBLIC;
        }
        return VisibilityModifier.DEFAULT;
    }

    private Class<? extends ClassFileDescriptor> getJavaType(int flags) {
        if (this.hasFlag(flags, 8192)) {
            return AnnotationTypeDescriptor.class;
        }
        if (this.hasFlag(flags, 16384)) {
            return EnumTypeDescriptor.class;
        }
        if (this.hasFlag(flags, 512)) {
            return InterfaceTypeDescriptor.class;
        }
        return ClassTypeDescriptor.class;
    }

    private void addInnerClass(TypeDescriptor outerClass, TypeDescriptor innerClass) {
        if (!innerClass.equals(outerClass)) {
            outerClass.getDeclaredInnerClasses().add(innerClass);
        }
    }
}

