/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.ManifestEntryDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ManifestFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ManifestSectionDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestFileScannerPlugin
extends AbstractScannerPlugin<FileResource, ManifestFileDescriptor> {
    public static final String SECTION_MAIN = "Main";

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals(scope) && "/META-INF/MANIFEST.MF".equals(path);
    }

    public ManifestFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        try (InputStream stream = item.createStream();){
            Manifest manifest = new Manifest(stream);
            Store store = scanner.getContext().getStore();
            ManifestFileDescriptor manifestFileDescriptor = (ManifestFileDescriptor)store.create(ManifestFileDescriptor.class);
            ManifestSectionDescriptor mainSectionDescriptor = (ManifestSectionDescriptor)store.create(ManifestSectionDescriptor.class);
            mainSectionDescriptor.setName(SECTION_MAIN);
            manifestFileDescriptor.setMainSection(mainSectionDescriptor);
            this.readSection(manifest.getMainAttributes(), mainSectionDescriptor, store);
            for (Map.Entry<String, Attributes> sectionEntry : manifest.getEntries().entrySet()) {
                ManifestSectionDescriptor sectionDescriptor = (ManifestSectionDescriptor)store.create(ManifestSectionDescriptor.class);
                sectionDescriptor.setName(sectionEntry.getKey());
                this.readSection(sectionEntry.getValue(), sectionDescriptor, store);
                manifestFileDescriptor.getManifestSections().add(sectionDescriptor);
            }
            ManifestFileDescriptor manifestFileDescriptor2 = manifestFileDescriptor;
            return manifestFileDescriptor2;
        }
    }

    private void readSection(Attributes attributes, ManifestSectionDescriptor sectionDescriptor, Store store) {
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            ManifestEntryDescriptor entryDescriptor = (ManifestEntryDescriptor)store.create(ManifestEntryDescriptor.class);
            entryDescriptor.setName(key != null ? key.toString() : null);
            entryDescriptor.setValue(value != null ? value.toString() : null);
            sectionDescriptor.getManifestEntries().add(entryDescriptor);
        }
    }
}

