/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractFileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import java.io.IOException;
import java.io.InputStream;

public class ClassTypeScannerPlugin
extends AbstractResourceScannerPlugin<Class<?>, ClassFileDescriptor> {
    public boolean accepts(Class<?> item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals(scope);
    }

    public ClassFileDescriptor scan(final Class<?> item, String path, Scope scope, Scanner scanner) throws IOException {
        final String fileName = "/" + item.getName().replace('.', '/') + ".class";
        AbstractFileResource fileResource = new AbstractFileResource(){

            public InputStream createStream() throws IOException {
                return item.getResourceAsStream(fileName);
            }
        };
        ClassFileDescriptor fileDescriptor = (ClassFileDescriptor)scanner.scan((Object)fileResource, fileName, scope);
        return (ClassFileDescriptor)this.toFileDescriptor((Resource)fileResource, fileDescriptor, fileName, scanner.getContext());
    }
}

