/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.ClassVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.objectweb.asm.ClassReader;

public class ClassFileScannerPlugin
extends AbstractScannerPlugin<FileResource, ClassFileDescriptor> {
    private static final byte[] CAFEBABE = new byte[]{-54, -2, -70, -66};

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        if (JavaScope.CLASSPATH.equals(scope) && path.endsWith(".class")) {
            try (InputStream stream = file.createStream();){
                byte[] header = new byte[4];
                stream.read(header);
                boolean bl = Arrays.equals(CAFEBABE, header);
                return bl;
            }
        }
        return false;
    }

    public ClassFileDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        VisitorHelper visitorHelper = new VisitorHelper(scanner.getContext());
        ClassVisitor visitor = new ClassVisitor(visitorHelper);
        try (InputStream stream = file.createStream();){
            new ClassReader(stream).accept((org.objectweb.asm.ClassVisitor)visitor, 0);
            ClassFileDescriptor classFileDescriptor = visitor.getTypeDescriptor();
            return classFileDescriptor;
        }
    }
}

