/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.Map;

public class TypeCache {
    private Cache<String, CachedType> lruCache = CacheBuilder.newBuilder().maximumSize(8192L).removalListener((RemovalListener)new RemovalListener<String, CachedType>(){

        public void onRemoval(RemovalNotification<String, CachedType> notification) {
            if (RemovalCause.SIZE.equals((Object)notification.getCause())) {
                TypeCache.this.softCache.put(notification.getKey(), notification.getValue());
            }
        }
    }).build();
    private Cache<String, CachedType> softCache = CacheBuilder.newBuilder().softValues().build();

    TypeCache() {
    }

    public CachedType get(String fullQualifiedName) {
        CachedType cachedType = (CachedType)this.lruCache.getIfPresent((Object)fullQualifiedName);
        if (cachedType != null) {
            return cachedType;
        }
        cachedType = (CachedType)this.softCache.getIfPresent((Object)fullQualifiedName);
        if (cachedType != null) {
            this.lruCache.put((Object)fullQualifiedName, (Object)cachedType);
        }
        return cachedType;
    }

    public void put(String fullQualifiedName, CachedType cachedType) {
        this.lruCache.put((Object)fullQualifiedName, (Object)cachedType);
    }

    public static class CachedType<T extends TypeDescriptor> {
        private T typeDescriptor;
        private Map<String, MemberDescriptor> members = new HashMap<String, MemberDescriptor>();
        private Map<String, TypeDescriptor> dependencies = new HashMap<String, TypeDescriptor>();

        public CachedType(T typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public T getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public void migrate(T typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public FieldDescriptor getField(String signature) {
            return (FieldDescriptor)this.members.get(signature);
        }

        public MethodDescriptor getMethod(String signature) {
            return (MethodDescriptor)this.members.get(signature);
        }

        public void addMember(String signature, MemberDescriptor member) {
            this.members.put(signature, member);
        }

        public TypeDescriptor getDependency(String fullQualifiedName) {
            return this.dependencies.get(fullQualifiedName);
        }

        public void addDependency(String fullQualifiedName, TypeDescriptor dependency) {
            this.dependencies.put(fullQualifiedName, dependency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedType)) {
                return false;
            }
            CachedType that = (CachedType)o;
            return this.typeDescriptor.equals(that.typeDescriptor);
        }

        public int hashCode() {
            return this.typeDescriptor.hashCode();
        }
    }
}

