/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DependsOnDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.AbstractTypeResolver;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.ResultIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ArtifactBasedTypeResolver
extends AbstractTypeResolver {
    private JavaArtifactFileDescriptor artifact;
    private List<ArtifactDescriptor> dependencies;
    private Map<String, TypeDescriptor> artifactTypes = new HashMap<String, TypeDescriptor>();

    ArtifactBasedTypeResolver(JavaArtifactFileDescriptor artifact) {
        this.artifact = artifact;
        for (FileDescriptor fileDescriptor : artifact.getContains()) {
            if (!(fileDescriptor instanceof TypeDescriptor)) continue;
            TypeDescriptor typeDescriptor = (TypeDescriptor)fileDescriptor;
            this.artifactTypes.put(typeDescriptor.getFullQualifiedName(), typeDescriptor);
        }
        for (TypeDescriptor typeDescriptor : artifact.getRequiresTypes()) {
            this.artifactTypes.put(typeDescriptor.getFullQualifiedName(), typeDescriptor);
        }
        this.dependencies = new ArrayList<ArtifactDescriptor>();
        for (DependsOnDescriptor dependsOnDescriptor : artifact.getDependencies()) {
            this.dependencies.add(dependsOnDescriptor.getDependency());
        }
    }

    @Override
    protected TypeDescriptor findInArtifact(String fullQualifiedName, ScannerContext context) {
        return this.artifactTypes.get(fullQualifiedName);
    }

    @Override
    protected TypeDescriptor findInDependencies(String fullQualifiedName, ScannerContext context) {
        Query.Result<TypeDescriptor> typeDescriptors;
        ResultIterator iterator;
        TypeDescriptor typeDescriptor = null;
        if (!this.dependencies.isEmpty() && (iterator = (typeDescriptors = this.artifact.resolveRequiredType(fullQualifiedName, this.dependencies)).iterator()).hasNext()) {
            typeDescriptor = (TypeDescriptor)iterator.next();
        }
        return typeDescriptor;
    }

    @Override
    protected void addContainedType(String fqn, TypeDescriptor typeDescriptor) {
        this.artifactTypes.put(fqn, typeDescriptor);
    }

    @Override
    protected void addRequiredType(String fqn, TypeDescriptor typeDescriptor) {
        this.artifactTypes.put(fqn, typeDescriptor);
        typeDescriptor.setRequiredBy(this.artifact);
    }

    @Override
    protected <T extends TypeDescriptor> void removeRequiredType(String fqn, T typeDescriptor) {
        typeDescriptor.setRequiredBy(null);
    }
}

