/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;

public abstract class AbstractTypeResolver
implements TypeResolver {
    private TypeCache typeCache = new TypeCache();

    protected AbstractTypeResolver() {
    }

    @Override
    public <T extends TypeDescriptor> TypeCache.CachedType<T> create(String fullQualifiedName, Class<T> descriptorType, ScannerContext context) {
        TypeCache.CachedType cachedType = this.typeCache.get(fullQualifiedName);
        if (cachedType == null) {
            TypeDescriptor resolvedType = this.findInArtifact(fullQualifiedName, context);
            Object typeDescriptor = resolvedType == null ? this.createDescriptor(fullQualifiedName, descriptorType, context) : (!descriptorType.isAssignableFrom(resolvedType.getClass()) ? this.migrateDescriptor(fullQualifiedName, resolvedType, descriptorType, context) : (TypeDescriptor)descriptorType.cast(resolvedType));
            cachedType = this.toCachedType((TypeDescriptor)typeDescriptor);
            this.typeCache.put(fullQualifiedName, cachedType);
        } else {
            Object resolvedType = cachedType.getTypeDescriptor();
            if (!descriptorType.isAssignableFrom(resolvedType.getClass())) {
                T typeDescriptor = this.migrateDescriptor(fullQualifiedName, (TypeDescriptor)resolvedType, descriptorType, context);
                cachedType.migrate(typeDescriptor);
            }
        }
        this.addContainedType(fullQualifiedName, (TypeDescriptor)cachedType.getTypeDescriptor());
        return cachedType;
    }

    @Override
    public TypeCache.CachedType<TypeDescriptor> resolve(String fullQualifiedName, ScannerContext context) {
        TypeCache.CachedType cachedType = this.typeCache.get(fullQualifiedName);
        if (cachedType == null) {
            TypeDescriptor typeDescriptor = this.findInArtifact(fullQualifiedName, context);
            if (typeDescriptor == null) {
                typeDescriptor = this.findInDependencies(fullQualifiedName, context);
            }
            if (typeDescriptor == null) {
                typeDescriptor = this.createDescriptor(fullQualifiedName, TypeDescriptor.class, context);
                this.addRequiredType(fullQualifiedName, typeDescriptor);
            }
            cachedType = this.toCachedType(typeDescriptor);
            this.typeCache.put(fullQualifiedName, cachedType);
        }
        return cachedType;
    }

    private <T extends TypeDescriptor> T createDescriptor(String fullQualifiedName, Class<T> descriptorType, ScannerContext scannerContext) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)scannerContext.getStore().create(descriptorType);
        int separatorIndex = fullQualifiedName.lastIndexOf(46);
        String name = separatorIndex != -1 ? fullQualifiedName.substring(separatorIndex + 1) : fullQualifiedName;
        typeDescriptor.setName(name);
        typeDescriptor.setFullQualifiedName(fullQualifiedName);
        return (T)typeDescriptor;
    }

    private <T extends TypeDescriptor> T migrateDescriptor(String fqn, TypeDescriptor resolvedType, Class<T> descriptorType, ScannerContext context) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)context.getStore().migrate((Descriptor)resolvedType, descriptorType, new Class[0]);
        this.removeRequiredType(fqn, typeDescriptor);
        return (T)typeDescriptor;
    }

    private TypeCache.CachedType toCachedType(TypeDescriptor typeDescriptor) {
        TypeCache.CachedType<TypeDescriptor> cachedType = new TypeCache.CachedType<TypeDescriptor>(typeDescriptor);
        for (Descriptor descriptor : typeDescriptor.getDeclaredMembers()) {
            if (!(descriptor instanceof MemberDescriptor)) continue;
            MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor;
            cachedType.addMember(memberDescriptor.getSignature(), memberDescriptor);
        }
        for (TypeDescriptor typeDescriptor2 : typeDescriptor.getDependencies()) {
            cachedType.addDependency(typeDescriptor2.getFullQualifiedName(), typeDescriptor);
        }
        return cachedType;
    }

    protected abstract TypeDescriptor findInArtifact(String var1, ScannerContext var2);

    protected abstract TypeDescriptor findInDependencies(String var1, ScannerContext var2);

    protected abstract void addRequiredType(String var1, TypeDescriptor var2);

    protected abstract void addContainedType(String var1, TypeDescriptor var2);

    protected abstract <T extends TypeDescriptor> void removeRequiredType(String var1, T var2);
}

