/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.javaee6.impl.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.javaee6.api.model.DescriptionDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.DisplayNameDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.IconDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.RoleNameDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.SecurityRoleDescriptor;
import com.sun.java.xml.ns.javaee.DescriptionType;
import com.sun.java.xml.ns.javaee.DisplayNameType;
import com.sun.java.xml.ns.javaee.IconType;
import com.sun.java.xml.ns.javaee.PathType;
import com.sun.java.xml.ns.javaee.RoleNameType;
import com.sun.java.xml.ns.javaee.SecurityRoleType;

public class XmlDescriptorHelper {
    private XmlDescriptorHelper() {
    }

    public static DescriptionDescriptor createDescription(DescriptionType descriptionType, Store store) {
        DescriptionDescriptor descriptionDescriptor = (DescriptionDescriptor)store.create(DescriptionDescriptor.class);
        descriptionDescriptor.setLang(descriptionType.getLang());
        descriptionDescriptor.setValue(descriptionType.getValue());
        return descriptionDescriptor;
    }

    public static IconDescriptor createIcon(IconType iconType, Store store) {
        PathType smallIcon;
        IconDescriptor iconDescriptor = (IconDescriptor)store.create(IconDescriptor.class);
        iconDescriptor.setLang(iconType.getLang());
        PathType largeIcon = iconType.getLargeIcon();
        if (largeIcon != null) {
            iconDescriptor.setLargeIcon(largeIcon.getValue());
        }
        if ((smallIcon = iconType.getSmallIcon()) != null) {
            iconDescriptor.setSmallIcon(smallIcon.getValue());
        }
        return iconDescriptor;
    }

    public static DisplayNameDescriptor createDisplayName(DisplayNameType displayNameType, Store store) {
        DisplayNameDescriptor displayNameDescriptor = (DisplayNameDescriptor)store.create(DisplayNameDescriptor.class);
        displayNameDescriptor.setLang(displayNameType.getLang());
        displayNameDescriptor.setValue(displayNameType.getValue());
        return displayNameDescriptor;
    }

    public static SecurityRoleDescriptor createSecurityRole(SecurityRoleType securityRoleType, Store store) {
        SecurityRoleDescriptor securityRoleDescriptor = (SecurityRoleDescriptor)store.create(SecurityRoleDescriptor.class);
        for (DescriptionType descriptionType : securityRoleType.getDescription()) {
            securityRoleDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
        }
        securityRoleDescriptor.setRoleName(XmlDescriptorHelper.createRoleName(securityRoleType.getRoleName(), store));
        return securityRoleDescriptor;
    }

    public static RoleNameDescriptor createRoleName(RoleNameType roleNameType, Store store) {
        RoleNameDescriptor roleNameDescriptor = (RoleNameDescriptor)store.create(RoleNameDescriptor.class);
        roleNameDescriptor.setName(roleNameType.getValue());
        return roleNameDescriptor;
    }
}

