/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.javaee6.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.core.store.api.model.NamedDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.JavaClassesDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.javaee6.api.model.AsyncSupportedDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.AuthConstraintDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.DescriptionDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.DispatcherDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ErrorPageDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.FilterDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.FilterMappingDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.FormLoginConfigDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.HttpMethodDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.HttpMethodOmissionDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.IconDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ListenerDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.LoginConfigDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.MultipartConfigDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ParamValueDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.RoleNameDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.RunAsDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.SecurityConstraintDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.SecurityRoleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.SecurityRoleRefDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ServletDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ServletMappingDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.SessionConfigDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.UrlPatternDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.UserDataConstraintDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.WebResourceCollectionDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.WebXmlDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.scanner.WebApplicationScope;
import com.buschmais.jqassistant.plugin.javaee6.impl.scanner.AbstractWarResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.javaee6.impl.scanner.XmlDescriptorHelper;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import com.sun.java.xml.ns.javaee.AuthConstraintType;
import com.sun.java.xml.ns.javaee.AuthMethodType;
import com.sun.java.xml.ns.javaee.DescriptionType;
import com.sun.java.xml.ns.javaee.DispatcherType;
import com.sun.java.xml.ns.javaee.DisplayNameType;
import com.sun.java.xml.ns.javaee.ErrorCodeType;
import com.sun.java.xml.ns.javaee.ErrorPageType;
import com.sun.java.xml.ns.javaee.FilterMappingType;
import com.sun.java.xml.ns.javaee.FilterNameType;
import com.sun.java.xml.ns.javaee.FilterType;
import com.sun.java.xml.ns.javaee.FormLoginConfigType;
import com.sun.java.xml.ns.javaee.FullyQualifiedClassType;
import com.sun.java.xml.ns.javaee.IconType;
import com.sun.java.xml.ns.javaee.JspFileType;
import com.sun.java.xml.ns.javaee.ListenerType;
import com.sun.java.xml.ns.javaee.LoginConfigType;
import com.sun.java.xml.ns.javaee.MultipartConfigType;
import com.sun.java.xml.ns.javaee.ObjectFactory;
import com.sun.java.xml.ns.javaee.ParamValueType;
import com.sun.java.xml.ns.javaee.RoleNameType;
import com.sun.java.xml.ns.javaee.RunAsType;
import com.sun.java.xml.ns.javaee.SecurityConstraintType;
import com.sun.java.xml.ns.javaee.SecurityRoleRefType;
import com.sun.java.xml.ns.javaee.SecurityRoleType;
import com.sun.java.xml.ns.javaee.ServletMappingType;
import com.sun.java.xml.ns.javaee.ServletNameType;
import com.sun.java.xml.ns.javaee.ServletType;
import com.sun.java.xml.ns.javaee.SessionConfigType;
import com.sun.java.xml.ns.javaee.String;
import com.sun.java.xml.ns.javaee.TrueFalseType;
import com.sun.java.xml.ns.javaee.UrlPatternType;
import com.sun.java.xml.ns.javaee.UserDataConstraintType;
import com.sun.java.xml.ns.javaee.WebAppType;
import com.sun.java.xml.ns.javaee.WebResourceCollectionType;
import com.sun.java.xml.ns.javaee.XsdIntegerType;
import com.sun.java.xml.ns.javaee.XsdStringType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class WebXmlScannerPlugin
extends AbstractWarResourceScannerPlugin<FileResource, WebXmlDescriptor> {
    private JAXBContext jaxbContext;

    protected void initialize() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    public boolean accepts(FileResource item, java.lang.String path, Scope scope) throws IOException {
        return WebApplicationScope.WAR.equals(scope) && "/WEB-INF/web.xml".equals(path);
    }

    @Override
    public WebXmlDescriptor scan(FileResource item, java.lang.String path, JavaClassesDirectoryDescriptor classesDirectory, Scanner scanner) throws IOException {
        WebAppType webAppType;
        try (InputStream stream = item.createStream();){
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            webAppType = (WebAppType)unmarshaller.unmarshal((Source)new StreamSource(stream), WebAppType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read " + path, e);
        }
        Store store = scanner.getContext().getStore();
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        WebXmlDescriptor webXmlDescriptor = (WebXmlDescriptor)store.addDescriptorType((Descriptor)xmlFileDescriptor, WebXmlDescriptor.class);
        webXmlDescriptor.setVersion(webAppType.getVersion());
        HashMap<java.lang.String, ServletDescriptor> servlets = new HashMap<java.lang.String, ServletDescriptor>();
        HashMap<java.lang.String, FilterDescriptor> filters = new HashMap<java.lang.String, FilterDescriptor>();
        for (JAXBElement<?> jaxbElement : webAppType.getModuleNameOrDescriptionAndDisplayName()) {
            Object value = jaxbElement.getValue();
            if (value instanceof ParamValueType) {
                ParamValueDescriptor paramValue = this.createParamValue((ParamValueType)value, store);
                webXmlDescriptor.getContextParams().add(paramValue);
                continue;
            }
            if (value instanceof ErrorPageType) {
                ErrorPageDescriptor errorPageDescriptor = this.createErrorPage((ErrorPageType)value, scanner.getContext());
                webXmlDescriptor.getErrorPages().add(errorPageDescriptor);
                continue;
            }
            if (value instanceof ServletMappingType) {
                ServletMappingDescriptor servletMappingDescriptor = this.createServletMapping((ServletMappingType)value, servlets, store);
                webXmlDescriptor.getServletMappings().add(servletMappingDescriptor);
                continue;
            }
            if (value instanceof SessionConfigType) {
                SessionConfigDescriptor sessionConfig = this.createSessionConfig((SessionConfigType)value, store);
                webXmlDescriptor.setSessionConfig(sessionConfig);
                continue;
            }
            if (value instanceof FilterType) {
                FilterType filterType = (FilterType)value;
                FilterDescriptor filterDescriptor = this.createFilter(filterType, filters, scanner.getContext());
                webXmlDescriptor.getFilters().add(filterDescriptor);
                continue;
            }
            if (value instanceof FilterMappingType) {
                FilterMappingDescriptor filterMapping = this.createFilterMapping((FilterMappingType)value, filters, servlets, store);
                webXmlDescriptor.getFilterMappings().add(filterMapping);
                continue;
            }
            if (value instanceof ServletType) {
                ServletDescriptor servletDescriptor = this.createServlet((ServletType)value, servlets, scanner.getContext());
                webXmlDescriptor.getServlets().add(servletDescriptor);
                continue;
            }
            if (value instanceof ListenerType) {
                ListenerDescriptor listenerDescriptor = this.createListener((ListenerType)value, scanner.getContext());
                webXmlDescriptor.getListeners().add(listenerDescriptor);
                continue;
            }
            if (value instanceof SecurityConstraintType) {
                SecurityConstraintDescriptor securityConstraintDescriptor = this.createSecurityConstraint((SecurityConstraintType)value, store);
                webXmlDescriptor.getSecurityConstraints().add(securityConstraintDescriptor);
                continue;
            }
            if (value instanceof SecurityRoleType) {
                SecurityRoleDescriptor securityRoleDescriptor = XmlDescriptorHelper.createSecurityRole((SecurityRoleType)value, store);
                webXmlDescriptor.getSecurityRoles().add(securityRoleDescriptor);
                continue;
            }
            if (!(value instanceof LoginConfigType)) continue;
            LoginConfigDescriptor loginConfigDescriptor = this.createLoginConfig((LoginConfigType)value, store);
            webXmlDescriptor.getLoginConfigs().add(loginConfigDescriptor);
        }
        return webXmlDescriptor;
    }

    private LoginConfigDescriptor createLoginConfig(LoginConfigType loginConfigType, Store store) {
        String realmName;
        FormLoginConfigType formLoginConfigType;
        LoginConfigDescriptor loginConfigDescriptor = (LoginConfigDescriptor)store.create(LoginConfigDescriptor.class);
        AuthMethodType authMethod = loginConfigType.getAuthMethod();
        if (authMethod != null) {
            loginConfigDescriptor.setAuthMethod(authMethod.getValue());
        }
        if ((formLoginConfigType = loginConfigType.getFormLoginConfig()) != null) {
            FormLoginConfigDescriptor formLoginConfigDescriptor = (FormLoginConfigDescriptor)store.create(FormLoginConfigDescriptor.class);
            formLoginConfigDescriptor.setFormLoginPage(formLoginConfigType.getFormLoginPage().getValue());
            formLoginConfigDescriptor.setFormErrorPage(formLoginConfigType.getFormErrorPage().getValue());
            loginConfigDescriptor.setFormLoginConfig(formLoginConfigDescriptor);
        }
        if ((realmName = loginConfigType.getRealmName()) != null) {
            loginConfigDescriptor.setRealmName(realmName.getValue());
        }
        return loginConfigDescriptor;
    }

    private SecurityConstraintDescriptor createSecurityConstraint(SecurityConstraintType securityConstraintType, Store store) {
        AuthConstraintType authConstraint;
        SecurityConstraintDescriptor securityConstraintDescriptor = (SecurityConstraintDescriptor)store.create(SecurityConstraintDescriptor.class);
        for (DisplayNameType displayNameType : securityConstraintType.getDisplayName()) {
            securityConstraintDescriptor.getDisplayNames().add(XmlDescriptorHelper.createDisplayName(displayNameType, store));
        }
        UserDataConstraintType userDataConstraint = securityConstraintType.getUserDataConstraint();
        if (userDataConstraint != null) {
            UserDataConstraintDescriptor userDataConstraintDescriptor = (UserDataConstraintDescriptor)store.create(UserDataConstraintDescriptor.class);
            userDataConstraintDescriptor.setTransportGuarantee(userDataConstraint.getTransportGuarantee().getValue());
            for (DescriptionType descriptionType : userDataConstraint.getDescription()) {
                userDataConstraintDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
            }
            securityConstraintDescriptor.getUserDataConstraints().add(userDataConstraintDescriptor);
        }
        if ((authConstraint = securityConstraintType.getAuthConstraint()) != null) {
            AuthConstraintDescriptor authConstraintDescriptor = (AuthConstraintDescriptor)store.create(AuthConstraintDescriptor.class);
            for (DescriptionType descriptionType : authConstraint.getDescription()) {
                authConstraintDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
            }
            for (RoleNameType roleNameType : authConstraint.getRoleName()) {
                RoleNameDescriptor roleNameDescriptor = XmlDescriptorHelper.createRoleName(roleNameType, store);
                authConstraintDescriptor.getRoleNames().add(roleNameDescriptor);
            }
            securityConstraintDescriptor.getAuthConstraints().add(authConstraintDescriptor);
        }
        for (WebResourceCollectionType webResourceCollectionType : securityConstraintType.getWebResourceCollection()) {
            WebResourceCollectionDescriptor webResourceCollectionDescriptor = (WebResourceCollectionDescriptor)store.create(WebResourceCollectionDescriptor.class);
            webResourceCollectionDescriptor.setName(webResourceCollectionType.getWebResourceName().getValue());
            for (DescriptionType descriptionType : webResourceCollectionType.getDescription()) {
                webResourceCollectionDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
            }
            for (java.lang.String httpMethod : webResourceCollectionType.getHttpMethod()) {
                HttpMethodDescriptor httpMethodDescriptor = (HttpMethodDescriptor)store.create(HttpMethodDescriptor.class);
                httpMethodDescriptor.setName(httpMethod);
                webResourceCollectionDescriptor.getHttpMethods().add(httpMethodDescriptor);
            }
            for (java.lang.String httpMethodOmission : webResourceCollectionType.getHttpMethodOmission()) {
                HttpMethodOmissionDescriptor httpMethodOmissionDescriptor = (HttpMethodOmissionDescriptor)store.create(HttpMethodOmissionDescriptor.class);
                httpMethodOmissionDescriptor.setName(httpMethodOmission);
                webResourceCollectionDescriptor.getHttpMethodOmissions().add(httpMethodOmissionDescriptor);
            }
            for (UrlPatternType urlPatternType : webResourceCollectionType.getUrlPattern()) {
                UrlPatternDescriptor urlPatternDescriptor = this.createUrlPattern(urlPatternType, store);
                webResourceCollectionDescriptor.getUrlPatterns().add(urlPatternDescriptor);
            }
            securityConstraintDescriptor.getWebResourceCollections().add(webResourceCollectionDescriptor);
        }
        return securityConstraintDescriptor;
    }

    private ListenerDescriptor createListener(ListenerType listenerType, ScannerContext context) {
        Store store = context.getStore();
        ListenerDescriptor listenerDescriptor = (ListenerDescriptor)store.create(ListenerDescriptor.class);
        for (DescriptionType descriptionType : listenerType.getDescription()) {
            listenerDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
        }
        for (DisplayNameType displayNameType : listenerType.getDisplayName()) {
            listenerDescriptor.getDisplayNames().add(XmlDescriptorHelper.createDisplayName(displayNameType, store));
        }
        for (IconType iconType : listenerType.getIcon()) {
            listenerDescriptor.getIcons().add(XmlDescriptorHelper.createIcon(iconType, store));
        }
        TypeResolver typeResolver = (TypeResolver)context.peek(TypeResolver.class);
        FullyQualifiedClassType listenerClass = listenerType.getListenerClass();
        TypeCache.CachedType listenerClassDescriptor = typeResolver.resolve(listenerClass.getValue(), context);
        listenerDescriptor.setType(listenerClassDescriptor.getTypeDescriptor());
        return listenerDescriptor;
    }

    private ErrorPageDescriptor createErrorPage(ErrorPageType errorPageType, ScannerContext context) {
        FullyQualifiedClassType exceptionType;
        ErrorPageDescriptor errorPageDescriptor = (ErrorPageDescriptor)context.getStore().create(ErrorPageDescriptor.class);
        ErrorCodeType errorCode = errorPageType.getErrorCode();
        if (errorCode != null) {
            errorPageDescriptor.setErrorCode(errorCode.getValue().intValue());
        }
        if ((exceptionType = errorPageType.getExceptionType()) != null) {
            TypeResolver typeResolver = (TypeResolver)context.peek(TypeResolver.class);
            TypeCache.CachedType cachedType = typeResolver.resolve(exceptionType.getValue(), context);
            errorPageDescriptor.setExceptionType(cachedType.getTypeDescriptor());
        }
        errorPageDescriptor.setErrorPage(errorPageType.getLocation().getValue());
        return errorPageDescriptor;
    }

    private FilterDescriptor createFilter(FilterType filterType, Map<java.lang.String, FilterDescriptor> filters, ScannerContext context) {
        Store store = context.getStore();
        FilterDescriptor filterDescriptor = this.getOrCreateNamedDescriptor(FilterDescriptor.class, filterType.getFilterName().getValue(), filters, store);
        this.setAsyncSupported(filterDescriptor, filterType.getAsyncSupported());
        for (DescriptionType descriptionType : filterType.getDescription()) {
            filterDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
        }
        for (DisplayNameType displayNameType : filterType.getDisplayName()) {
            filterDescriptor.getDisplayNames().add(XmlDescriptorHelper.createDisplayName(displayNameType, store));
        }
        FullyQualifiedClassType filterClass = filterType.getFilterClass();
        if (filterClass != null) {
            TypeResolver typeResolver = (TypeResolver)context.peek(TypeResolver.class);
            TypeCache.CachedType filterClassDescriptor = typeResolver.resolve(filterClass.getValue(), context);
            filterDescriptor.setType(filterClassDescriptor.getTypeDescriptor());
        }
        for (IconType iconType : filterType.getIcon()) {
            IconDescriptor iconDescriptor = XmlDescriptorHelper.createIcon(iconType, store);
            filterDescriptor.getIcons().add(iconDescriptor);
        }
        for (ParamValueType paramValueType : filterType.getInitParam()) {
            ParamValueDescriptor paramValueDescriptor = this.createParamValue(paramValueType, store);
            filterDescriptor.getInitParams().add(paramValueDescriptor);
        }
        return filterDescriptor;
    }

    private FilterMappingDescriptor createFilterMapping(FilterMappingType filterMappingType, Map<java.lang.String, FilterDescriptor> filters, Map<java.lang.String, ServletDescriptor> servlets, Store store) {
        FilterMappingDescriptor filterMappingDescriptor = (FilterMappingDescriptor)store.create(FilterMappingDescriptor.class);
        FilterNameType filterName = filterMappingType.getFilterName();
        FilterDescriptor filterDescriptor = this.getOrCreateNamedDescriptor(FilterDescriptor.class, filterName.getValue(), filters, store);
        filterDescriptor.getMappings().add(filterMappingDescriptor);
        for (Object urlPatternOrServletName : filterMappingType.getUrlPatternOrServletName()) {
            if (urlPatternOrServletName instanceof UrlPatternType) {
                UrlPatternType urlPatternType = (UrlPatternType)urlPatternOrServletName;
                UrlPatternDescriptor urlPatternDescriptor = this.createUrlPattern(urlPatternType, store);
                filterMappingDescriptor.getUrlPatterns().add(urlPatternDescriptor);
                continue;
            }
            if (!(urlPatternOrServletName instanceof ServletNameType)) continue;
            ServletNameType servletNameType = (ServletNameType)urlPatternOrServletName;
            ServletDescriptor servletDescriptor = this.getOrCreateNamedDescriptor(ServletDescriptor.class, servletNameType.getValue(), servlets, store);
            filterMappingDescriptor.setServlet(servletDescriptor);
        }
        for (DispatcherType dispatcherType : filterMappingType.getDispatcher()) {
            DispatcherDescriptor dispatcherDescriptor = (DispatcherDescriptor)store.create(DispatcherDescriptor.class);
            dispatcherDescriptor.setValue(dispatcherType.getValue());
            filterMappingDescriptor.getDispatchers().add(dispatcherDescriptor);
        }
        return filterMappingDescriptor;
    }

    private UrlPatternDescriptor createUrlPattern(UrlPatternType urlPatternType, Store store) {
        UrlPatternDescriptor urlPatternDescriptor = (UrlPatternDescriptor)store.create(UrlPatternDescriptor.class);
        urlPatternDescriptor.setValue(urlPatternType.getValue());
        return urlPatternDescriptor;
    }

    private ServletDescriptor createServlet(ServletType servletType, Map<java.lang.String, ServletDescriptor> servlets, ScannerContext context) {
        RunAsType runAs;
        MultipartConfigType multipartConfig;
        java.lang.String loadOnStartup;
        Store store = context.getStore();
        ServletDescriptor servletDescriptor = this.getOrCreateNamedDescriptor(ServletDescriptor.class, servletType.getServletName().getValue(), servlets, store);
        this.setAsyncSupported(servletDescriptor, servletType.getAsyncSupported());
        for (DescriptionType descriptionType : servletType.getDescription()) {
            servletDescriptor.getDescriptions().add(XmlDescriptorHelper.createDescription(descriptionType, store));
        }
        for (DisplayNameType displayNameType : servletType.getDisplayName()) {
            servletDescriptor.getDisplayNames().add(XmlDescriptorHelper.createDisplayName(displayNameType, store));
        }
        TrueFalseType enabled = servletType.getEnabled();
        if (enabled != null) {
            servletDescriptor.setEnabled(enabled.isValue());
        }
        for (IconType iconType : servletType.getIcon()) {
            IconDescriptor iconDescriptor = XmlDescriptorHelper.createIcon(iconType, store);
            servletDescriptor.getIcons().add(iconDescriptor);
        }
        for (ParamValueType paramValueType : servletType.getInitParam()) {
            ParamValueDescriptor paramValueDescriptor = this.createParamValue(paramValueType, store);
            servletDescriptor.getInitParams().add(paramValueDescriptor);
        }
        JspFileType jspFileType = servletType.getJspFile();
        if (jspFileType != null) {
            servletDescriptor.setJspFile(jspFileType.getValue());
        }
        if ((loadOnStartup = servletType.getLoadOnStartup()) != null) {
            servletDescriptor.setLoadOnStartup(loadOnStartup.toUpperCase());
        }
        if ((multipartConfig = servletType.getMultipartConfig()) != null) {
            MultipartConfigDescriptor multipartConfigDescriptor = (MultipartConfigDescriptor)store.create(MultipartConfigDescriptor.class);
            BigInteger fileSizeThreshold = multipartConfig.getFileSizeThreshold();
            if (fileSizeThreshold != null) {
                multipartConfigDescriptor.setFileSizeThreshold(fileSizeThreshold.longValue());
            }
            multipartConfigDescriptor.setLocation(multipartConfig.getLocation());
            multipartConfigDescriptor.setMaxFileSize(multipartConfig.getMaxFileSize());
            multipartConfigDescriptor.setMaxRequestSize(multipartConfig.getMaxRequestSize());
            servletDescriptor.setMultipartConfig(multipartConfigDescriptor);
        }
        if ((runAs = servletType.getRunAs()) != null) {
            RunAsDescriptor runAsDescriptor = (RunAsDescriptor)store.create(RunAsDescriptor.class);
            for (DescriptionType descriptionType : runAs.getDescription()) {
                DescriptionDescriptor descriptionDescriptor = XmlDescriptorHelper.createDescription(descriptionType, store);
                runAsDescriptor.getDescriptions().add(descriptionDescriptor);
            }
            RoleNameType roleName = runAs.getRoleName();
            if (roleName != null) {
                runAsDescriptor.setRoleName(roleName.getValue());
            }
            servletDescriptor.setRunAs(runAsDescriptor);
        }
        for (SecurityRoleRefType securityRoleRefType : servletType.getSecurityRoleRef()) {
            SecurityRoleRefDescriptor securityRoleRefDescriptor = (SecurityRoleRefDescriptor)store.create(SecurityRoleRefDescriptor.class);
            securityRoleRefDescriptor.setRoleName(securityRoleRefType.getRoleName().getValue());
            for (DescriptionType descriptionType : securityRoleRefType.getDescription()) {
                DescriptionDescriptor descriptionDescriptor = XmlDescriptorHelper.createDescription(descriptionType, store);
                securityRoleRefDescriptor.getDescriptions().add(descriptionDescriptor);
            }
            RoleNameType roleLink = securityRoleRefType.getRoleLink();
            if (roleLink != null) {
                securityRoleRefDescriptor.setRoleLink(roleLink.getValue());
            }
            servletDescriptor.getSecurityRoleRefs().add(securityRoleRefDescriptor);
        }
        FullyQualifiedClassType servletClass = servletType.getServletClass();
        if (servletClass != null) {
            TypeCache.CachedType servletClassType = ((TypeResolver)context.peek(TypeResolver.class)).resolve(servletClass.getValue(), context);
            servletDescriptor.setType(servletClassType.getTypeDescriptor());
        }
        return servletDescriptor;
    }

    private <T extends NamedDescriptor> T getOrCreateNamedDescriptor(Class<T> type, java.lang.String name, Map<java.lang.String, T> descriptors, Store store) {
        NamedDescriptor descriptor = (NamedDescriptor)descriptors.get(name);
        if (descriptor == null) {
            descriptor = (NamedDescriptor)store.create(type);
            descriptor.setName(name);
            descriptors.put(name, descriptor);
        }
        return (T)descriptor;
    }

    private ParamValueDescriptor createParamValue(ParamValueType paramValueType, Store store) {
        ParamValueDescriptor paramValueDescriptor = (ParamValueDescriptor)store.create(ParamValueDescriptor.class);
        for (DescriptionType descriptionType : paramValueType.getDescription()) {
            DescriptionDescriptor descriptionDescriptor = XmlDescriptorHelper.createDescription(descriptionType, store);
            paramValueDescriptor.getDescriptions().add(descriptionDescriptor);
        }
        paramValueDescriptor.setName(paramValueType.getParamName().getValue());
        XsdStringType paramValue = paramValueType.getParamValue();
        if (paramValue != null) {
            paramValueDescriptor.setValue(paramValue.getValue());
        }
        return paramValueDescriptor;
    }

    private void setAsyncSupported(AsyncSupportedDescriptor asyncSupportedDescriptor, TrueFalseType asyncSupported) {
        if (asyncSupported != null) {
            asyncSupportedDescriptor.setAsyncSupported(asyncSupported.isValue());
        }
    }

    private ServletMappingDescriptor createServletMapping(ServletMappingType servletMappingType, Map<java.lang.String, ServletDescriptor> servlets, Store store) {
        ServletMappingDescriptor servletMappingDescriptor = (ServletMappingDescriptor)store.create(ServletMappingDescriptor.class);
        ServletNameType servletName = servletMappingType.getServletName();
        ServletDescriptor servletDescriptor = this.getOrCreateNamedDescriptor(ServletDescriptor.class, servletName.getValue(), servlets, store);
        servletDescriptor.getMappings().add(servletMappingDescriptor);
        for (UrlPatternType urlPatternType : servletMappingType.getUrlPattern()) {
            UrlPatternDescriptor urlPatternDescriptor = this.createUrlPattern(urlPatternType, store);
            servletMappingDescriptor.getUrlPatterns().add(urlPatternDescriptor);
        }
        return servletMappingDescriptor;
    }

    private SessionConfigDescriptor createSessionConfig(SessionConfigType sessionConfigType, Store store) {
        SessionConfigDescriptor sessionConfigDescriptor = (SessionConfigDescriptor)store.create(SessionConfigDescriptor.class);
        XsdIntegerType sessionTimeout = sessionConfigType.getSessionTimeout();
        if (sessionTimeout != null) {
            sessionConfigDescriptor.setSessionTimeout(sessionTimeout.getValue().intValue());
        }
        return sessionConfigDescriptor;
    }
}

