/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.javaee6.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ApplicationXmlDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ClientModuleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.ConnectorModuleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.DescriptionDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.DisplayNameDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.EjbModuleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.EnterpriseApplicationModuleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.IconDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.SecurityRoleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.model.WebModuleDescriptor;
import com.buschmais.jqassistant.plugin.javaee6.api.scanner.EnterpriseApplicationScope;
import com.buschmais.jqassistant.plugin.javaee6.impl.scanner.XmlDescriptorHelper;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import com.sun.java.xml.ns.javaee.ApplicationType;
import com.sun.java.xml.ns.javaee.DescriptionType;
import com.sun.java.xml.ns.javaee.DisplayNameType;
import com.sun.java.xml.ns.javaee.GenericBooleanType;
import com.sun.java.xml.ns.javaee.IconType;
import com.sun.java.xml.ns.javaee.ModuleType;
import com.sun.java.xml.ns.javaee.ObjectFactory;
import com.sun.java.xml.ns.javaee.PathType;
import com.sun.java.xml.ns.javaee.SecurityRoleType;
import com.sun.java.xml.ns.javaee.String;
import com.sun.java.xml.ns.javaee.WebType;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ApplicationXmlScannerPlugin
extends AbstractResourceScannerPlugin<FileResource, ApplicationXmlDescriptor> {
    private JAXBContext jaxbContext;

    protected void initialize() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    public boolean accepts(FileResource item, java.lang.String path, Scope scope) throws IOException {
        return EnterpriseApplicationScope.EAR.equals(scope) && "/META-INF/application.xml".equals(path);
    }

    public ApplicationXmlDescriptor scan(FileResource item, java.lang.String path, Scope scope, Scanner scanner) throws IOException {
        PathType libraryDirectory;
        ApplicationType applicationType;
        try (InputStream stream = item.createStream();){
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            applicationType = (ApplicationType)unmarshaller.unmarshal((Source)new StreamSource(stream), ApplicationType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read " + path, e);
        }
        Store store = scanner.getContext().getStore();
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        ApplicationXmlDescriptor applicationXmlDescriptor = (ApplicationXmlDescriptor)store.addDescriptorType((Descriptor)xmlFileDescriptor, ApplicationXmlDescriptor.class);
        String applicationName = applicationType.getApplicationName();
        if (applicationName != null) {
            applicationXmlDescriptor.setName(applicationName.getValue());
        }
        applicationXmlDescriptor.setVersion(applicationType.getVersion());
        for (DisplayNameType displayNameType : applicationType.getDisplayName()) {
            DisplayNameDescriptor displayName = XmlDescriptorHelper.createDisplayName(displayNameType, store);
            applicationXmlDescriptor.getDisplayNames().add(displayName);
        }
        for (DescriptionType descriptionType : applicationType.getDescription()) {
            DescriptionDescriptor description = XmlDescriptorHelper.createDescription(descriptionType, store);
            applicationXmlDescriptor.getDescriptions().add(description);
        }
        for (IconType iconType : applicationType.getIcon()) {
            IconDescriptor icon = XmlDescriptorHelper.createIcon(iconType, store);
            applicationXmlDescriptor.getIcons().add(icon);
        }
        GenericBooleanType initializeInOrder = applicationType.getInitializeInOrder();
        if (initializeInOrder != null) {
            applicationXmlDescriptor.setInitializeInOrder(initializeInOrder.getValue());
        }
        if ((libraryDirectory = applicationType.getLibraryDirectory()) != null) {
            applicationXmlDescriptor.setLibraryDirectory(libraryDirectory.getValue());
        }
        for (ModuleType moduleType : applicationType.getModule()) {
            EnterpriseApplicationModuleDescriptor moduleDescriptor = null;
            PathType pathType = null;
            if (moduleType.getEjb() != null) {
                pathType = moduleType.getEjb();
                moduleDescriptor = (EnterpriseApplicationModuleDescriptor)store.create(EjbModuleDescriptor.class);
            } else if (moduleType.getWeb() != null) {
                WebType webType = moduleType.getWeb();
                pathType = webType.getWebUri();
                WebModuleDescriptor webModuleDescriptor = (WebModuleDescriptor)store.create(WebModuleDescriptor.class);
                webModuleDescriptor.setContextRoot(webType.getContextRoot().getValue());
                moduleDescriptor = webModuleDescriptor;
            } else if (moduleType.getConnector() != null) {
                pathType = moduleType.getConnector();
                moduleDescriptor = (EnterpriseApplicationModuleDescriptor)store.create(ConnectorModuleDescriptor.class);
            } else if (moduleType.getJava() != null) {
                pathType = moduleType.getJava();
                moduleDescriptor = (EnterpriseApplicationModuleDescriptor)store.create(ClientModuleDescriptor.class);
            }
            if (moduleDescriptor == null) continue;
            moduleDescriptor.setPath(pathType.getValue());
            applicationXmlDescriptor.getModules().add(moduleDescriptor);
        }
        for (SecurityRoleType securityRoleType : applicationType.getSecurityRole()) {
            SecurityRoleDescriptor securityRole = XmlDescriptorHelper.createSecurityRole(securityRoleType, store);
            applicationXmlDescriptor.getSecurityRoles().add(securityRole);
        }
        return applicationXmlDescriptor;
    }
}

