/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractFileResource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlScannerPlugin
extends AbstractResourceScannerPlugin<URL, FileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlScannerPlugin.class);

    public boolean accepts(URL item, String path, Scope scope) throws IOException {
        return true;
    }

    public FileDescriptor scan(final URL item, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.info("Scanning url '{}'.", (Object)item.toString());
        try (AbstractFileResource fileResource = new AbstractFileResource(){

            @Override
            public InputStream createStream() throws IOException {
                return new BufferedInputStream(item.openStream());
            }
        };){
            Descriptor descriptor = scanner.scan((Object)fileResource, path, scope);
            Object f = this.toFileDescriptor(fileResource, descriptor, path, scanner.getContext());
            return f;
        }
    }
}

