/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.GZipFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractFileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZIPFileScannerPlugin
extends AbstractResourceScannerPlugin<FileResource, FileDescriptor> {
    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(".gz");
    }

    public FileDescriptor scan(final FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        try (AbstractFileResource fileResource = new AbstractFileResource(){

            @Override
            public InputStream createStream() throws IOException {
                return new GZIPInputStream(item.createStream());
            }
        };){
            Store store = scanner.getContext().getStore();
            String uncompressedPath = path.substring(0, path.toLowerCase().indexOf(".gz"));
            FileDescriptor fileDescriptor = (FileDescriptor)scanner.scan((Object)fileResource, uncompressedPath, scope);
            GZipFileDescriptor archiveFileDescriptor = fileDescriptor != null ? (GZipFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, GZipFileDescriptor.class) : (GZipFileDescriptor)store.create(GZipFileDescriptor.class);
            Object f = this.toFileDescriptor(fileResource, archiveFileDescriptor, path, scanner.getContext());
            return f;
        }
    }
}

