/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class AbstractScannerPlugin<I, D extends Descriptor>
implements ScannerPlugin<I, D> {
    private Map<String, Object> properties;

    public void initialize(Map<String, Object> properties) {
        this.properties = properties;
        this.initialize();
    }

    public Class<? extends I> getType() {
        return this.getTypeParameter(AbstractScannerPlugin.class, 0);
    }

    public Class<? extends D> getDescriptorType() {
        return this.getTypeParameter(AbstractScannerPlugin.class, 1);
    }

    protected <T> Class<T> getTypeParameter(Class<?> expectedSuperClass, int genericTypeParameterIndex) {
        Class<?> thisClass = this.getClass();
        if (!thisClass.getSuperclass().equals(expectedSuperClass)) {
            throw new IllegalStateException("Cannot determine type argument of " + thisClass.getName());
        }
        Type genericSuperclass = thisClass.getGenericSuperclass();
        Type typeParameter = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[genericTypeParameterIndex];
        if (typeParameter instanceof ParameterizedType) {
            return (Class)((ParameterizedType)typeParameter).getRawType();
        }
        return (Class)typeParameter;
    }

    protected void initialize() {
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    protected <T> T getProperty(String name, Class<T> type) {
        return type.cast(this.properties.get(name));
    }

    protected String getStringProperty(String name, String defaultValue) {
        return this.getProperty(name, String.class, defaultValue);
    }

    private <T> T getProperty(String name, Class<T> type, T defaultValue) {
        Object o = this.properties.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (!type.isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("Found value of type " + o.getClass().getName() + "for property " + name + ", expected " + type.getName());
        }
        return type.cast(o);
    }

    protected String getDirectoryPath(File directory, File entry) {
        String relativePath;
        if (entry.equals(directory)) {
            relativePath = "/";
        } else {
            String filePath = entry.getAbsolutePath();
            String directoryPath = directory.getAbsolutePath();
            relativePath = filePath.substring(directoryPath.length()).replace(File.separator, "/");
        }
        return relativePath;
    }
}

