/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DirectoryDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.DirectoryResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import java.io.IOException;

public abstract class AbstractResourceScannerPlugin<I, D extends Descriptor>
extends AbstractScannerPlugin<I, D> {
    @Override
    public Class<? extends I> getType() {
        return this.getTypeParameter(AbstractResourceScannerPlugin.class, 0);
    }

    @Override
    public Class<? extends D> getDescriptorType() {
        return this.getTypeParameter(AbstractResourceScannerPlugin.class, 1);
    }

    protected String slashify(String path) {
        return path.replace('\\', '/');
    }

    protected <F extends FileDescriptor> F toFileDescriptor(Resource resource, Descriptor descriptor, String relativePath, ScannerContext context) throws IOException {
        FileDescriptor fileDescriptor;
        if (descriptor == null) {
            fileDescriptor = this.createFileDescriptor(resource, context);
        } else if (descriptor instanceof FileDescriptor) {
            fileDescriptor = (FileDescriptor)descriptor;
        } else {
            throw new IOException(descriptor + " must be extend from " + FileDescriptor.class);
        }
        fileDescriptor.setFileName(relativePath);
        return (F)fileDescriptor;
    }

    private FileDescriptor createFileDescriptor(Resource resource, ScannerContext context) throws IOException {
        Class type;
        if (resource instanceof DirectoryResource) {
            type = DirectoryDescriptor.class;
        } else if (resource instanceof FileResource) {
            type = FileDescriptor.class;
        } else {
            throw new IOException("Unsupported resource " + resource);
        }
        return (FileDescriptor)context.getStore().create(type);
    }
}

