/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileContainerDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerScannerPlugin<I, E, D extends FileContainerDescriptor>
extends AbstractResourceScannerPlugin<I, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContainerScannerPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final D scan(I container, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        D containerDescriptor = this.getContainerDescriptor(container, context);
        String containerPath = this.getContainerPath(container, path);
        containerDescriptor.setFileName(containerPath);
        LOGGER.info("Entering {}", (Object)containerPath);
        HashMap<String, FileDescriptor> files = new HashMap<String, FileDescriptor>();
        this.enterContainer(container, containerDescriptor, scanner.getContext());
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            String relativePath;
            Iterable<E> entries = this.getEntries(container);
            TreeMap<String, E> sortedEntries = new TreeMap<String, E>();
            for (E e : entries) {
                relativePath = this.getRelativePath(container, e);
                sortedEntries.put(relativePath, e);
            }
            for (Map.Entry entry : sortedEntries.entrySet()) {
                relativePath = (String)entry.getKey();
                Resource resource = this.getEntry(container, entry.getValue());
                Throwable throwable = null;
                try {
                    String parentName;
                    FileDescriptor fileDescriptor;
                    LOGGER.debug("Scanning {}", (Object)relativePath);
                    FileDescriptor descriptor = (FileDescriptor)scanner.scan((Object)resource, relativePath, scope);
                    descriptor = this.toFileDescriptor(resource, descriptor, relativePath, context);
                    files.put(relativePath, descriptor);
                    containerDescriptor.getContains().add(descriptor);
                    int separatorIndex = relativePath.lastIndexOf(47);
                    if (separatorIndex == -1 || !((fileDescriptor = (FileDescriptor)files.get(parentName = relativePath.substring(0, separatorIndex))) instanceof FileContainerDescriptor)) continue;
                    ((FileContainerDescriptor)((Object)fileDescriptor)).getContains().add(descriptor);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
        }
        catch (Throwable throwable) {
            this.leaveContainer(container, containerDescriptor, scanner.getContext());
            LOGGER.info("Leaving {} ({} entries, {} ms)", new Object[]{containerPath, files.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            throw throwable;
        }
        this.leaveContainer(container, containerDescriptor, scanner.getContext());
        LOGGER.info("Leaving {} ({} entries, {} ms)", new Object[]{containerPath, files.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return containerDescriptor;
    }

    protected abstract D getContainerDescriptor(I var1, ScannerContext var2);

    protected abstract Iterable<? extends E> getEntries(I var1) throws IOException;

    protected abstract String getContainerPath(I var1, String var2);

    protected abstract String getRelativePath(I var1, E var2);

    protected abstract void enterContainer(I var1, D var2, ScannerContext var3) throws IOException;

    protected abstract void leaveContainer(I var1, D var2, ScannerContext var3) throws IOException;

    protected abstract Resource getEntry(I var1, E var2);
}

