/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.ArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.util.zip.ZipFile;

public abstract class AbstractArchiveScannerPlugin<D extends ArchiveDescriptor>
extends AbstractScannerPlugin<FileResource, D> {
    @Override
    public Class<? extends FileResource> getType() {
        return FileResource.class;
    }

    @Override
    public Class<? extends D> getDescriptorType() {
        return this.getTypeParameter(AbstractArchiveScannerPlugin.class, 0);
    }

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(this.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D scan(FileResource file, String path, Scope currentScope, Scanner scanner) throws IOException {
        D archive = this.createArchive(file, path, scanner.getContext());
        ZipFile zipFile = new ZipFile(file.getFile());
        scanner.getContext().push(ArchiveDescriptor.class, archive);
        Scope archiveScope = this.createScope(currentScope, archive, scanner.getContext());
        try {
            scanner.scan((Object)zipFile, path, archiveScope);
        }
        finally {
            this.destroyScope(scanner.getContext());
            scanner.getContext().pop(ArchiveDescriptor.class);
        }
        return archive;
    }

    protected abstract String getExtension();

    protected abstract Scope createScope(Scope var1, D var2, ScannerContext var3);

    protected abstract void destroyScope(ScannerContext var1);

    protected abstract D createArchive(FileResource var1, String var2, ScannerContext var3);
}

