/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.ndk;

import android.util.JsonReader;
import android.util.JsonToken;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NativeInterface;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/bugsnag/android/ndk/ReportDiscardScanner;", "", "logger", "Lcom/bugsnag/android/Logger;", "enabledReleaseStages", "", "", "(Lcom/bugsnag/android/Logger;Ljava/util/Collection;)V", "shouldDiscard", "", "json", "Landroid/util/JsonReader;", "shouldDiscard$bugsnag_plugin_android_ndk_release", "report", "Ljava/io/File;", "shouldDiscardException", "shouldDiscardForApp", "shouldDiscardForExceptions", "bugsnag-plugin-android-ndk_release"})
@SourceDebugExtension(value={"SMAP\nReportDiscardScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportDiscardScanner.kt\ncom/bugsnag/android/ndk/ReportDiscardScanner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class ReportDiscardScanner {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Collection<String> enabledReleaseStages;

    public ReportDiscardScanner(@NotNull Logger logger, @NotNull Collection<String> enabledReleaseStages) {
        this.logger = logger;
        this.enabledReleaseStages = enabledReleaseStages;
    }

    public /* synthetic */ ReportDiscardScanner(Logger logger, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Collection collection2 = NativeInterface.getEnabledReleaseStages();
            if (collection2 == null) {
                collection2 = SetsKt.emptySet();
            }
            collection = collection2;
        }
        this(logger, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean shouldDiscard(@NotNull File report) {
        boolean bl;
        if (!StringsKt.endsWith$default((String)report.getName(), (String)".json", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)report.getName(), (String)".static_data.json", (boolean)false, (int)2, null)) {
            return true;
        }
        try {
            boolean bl2;
            Object object = report;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                boolean bl3;
                BufferedReader reader = (BufferedReader)object;
                boolean bl4 = false;
                Closeable closeable = (Closeable)new JsonReader((Reader)reader);
                Throwable throwable = null;
                try {
                    JsonReader json = (JsonReader)closeable;
                    boolean bl5 = false;
                    bl3 = this.shouldDiscard$bugsnag_plugin_android_ndk_release(json);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bl2 = bl3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            bl = bl2;
        }
        catch (Exception ex) {
            bl = false;
        }
        return bl;
    }

    @VisibleForTesting
    public final boolean shouldDiscard$bugsnag_plugin_android_ndk_release(@NotNull JsonReader json) {
        json.beginObject();
        boolean pendingAppCheck = true;
        boolean pendingExceptionsCheck = true;
        while (json.hasNext() && (pendingAppCheck || pendingExceptionsCheck)) {
            boolean discard;
            boolean bl;
            String nextName = json.nextName();
            String string = nextName;
            if (Intrinsics.areEqual((Object)string, (Object)"app")) {
                pendingAppCheck = false;
                bl = this.shouldDiscardForApp(json);
            } else if (Intrinsics.areEqual((Object)string, (Object)"exceptions")) {
                pendingExceptionsCheck = false;
                bl = this.shouldDiscardForExceptions(json);
            } else {
                json.skipValue();
                bl = false;
            }
            if (!(discard = bl)) continue;
            return true;
        }
        return false;
    }

    private final boolean shouldDiscardForApp(JsonReader json) {
        if (this.enabledReleaseStages.isEmpty()) {
            json.skipValue();
            return false;
        }
        json.beginObject();
        while (json.peek() != JsonToken.END_OBJECT) {
            String nextName = json.nextName();
            if (Intrinsics.areEqual((Object)nextName, (Object)"releaseStage")) {
                String releaseStage = json.nextString();
                if (this.enabledReleaseStages.contains(releaseStage)) continue;
                return true;
            }
            json.skipValue();
        }
        json.endObject();
        return false;
    }

    private final boolean shouldDiscardForExceptions(JsonReader json) {
        json.beginArray();
        while (json.peek() != JsonToken.END_ARRAY) {
            if (!this.shouldDiscardException(json)) continue;
            this.logger.d("Discarding native report due to errorClass");
            return true;
        }
        json.endArray();
        return false;
    }

    private final boolean shouldDiscardException(JsonReader json) {
        json.beginObject();
        while (json.peek() != JsonToken.END_OBJECT) {
            String name = json.nextName();
            if (Intrinsics.areEqual((Object)name, (Object)"errorClass")) {
                String errorClass = json.nextString();
                if (!NativeInterface.isDiscardErrorClass((String)errorClass)) continue;
                return true;
            }
            json.skipValue();
        }
        json.endObject();
        return false;
    }
}

