/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.ndk;

import android.os.Build;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.StateObserver;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.ndk.OpaqueValue;
import com.bugsnag.android.ndk.ReportDiscardScanner;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0082 J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u001b\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0086 J\t\u0010\u001b\u001a\u00020\u0011H\u0086 J!\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\bH\u0086 J!\u0010 \u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020!H\u0086 J!\u0010\"\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0086 J!\u0010#\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0086 J\t\u0010$\u001a\u00020\u0011H\u0086 J\u0011\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086 J\t\u0010&\u001a\u00020\u0011H\u0086 J\u0011\u0010'\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0013H\u0086 J\b\u0010(\u001a\u00020\u0011H\u0002J\u0017\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010*H\u0086 J\u0017\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b\u0018\u00010*H\u0086 J\t\u0010,\u001a\u00020-H\u0086 J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u0010/\u001a\u000202H\u0002J\u001d\u00103\u001a\u00020\u00112\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150*H\u0086 JY\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0015H\u0086 J\u0012\u0010?\u001a\u00020\b2\b\u0010@\u001a\u0004\u0018\u00010\u0018H\u0002J\u0011\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0013H\u0086 J\u0011\u0010C\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0013H\u0086 J\u0010\u0010D\u001a\u00020\u00112\u0006\u0010E\u001a\u00020FH\u0016J\t\u0010G\u001a\u00020\u0011H\u0086 J\t\u0010H\u001a\u00020\u0011H\u0086 J\u0019\u0010I\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0086 J\u0011\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\bH\u0086 J\u0011\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u0013H\u0086 J)\u0010N\u001a\u00020\u00112\u0006\u0010O\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u0015H\u0086 J\u0011\u0010R\u001a\u00020\u00112\u0006\u0010S\u001a\u00020\u0013H\u0086 J\u0013\u0010T\u001a\u00020\u00112\b\u0010U\u001a\u0004\u0018\u00010\u0013H\u0086 J\u0019\u0010V\u001a\u00020\u00112\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u0013H\u0086 J\u0011\u0010Y\u001a\u00020\u00112\u0006\u0010Z\u001a\u00020\bH\u0086 J\u0019\u0010[\u001a\u00020\u00112\u0006\u0010\\\u001a\u00020\b2\u0006\u0010]\u001a\u00020\u0013H\u0086 J\u0011\u0010^\u001a\u00020\u00112\u0006\u0010_\u001a\u00020\u0013H\u0086 J\u0011\u0010`\u001a\u00020\u00112\u0006\u0010\\\u001a\u00020\u0013H\u0086 J\u0011\u0010a\u001a\u00020\u00112\u0006\u0010\\\u001a\u00020\u0013H\u0086 J\u0011\u0010b\u001a\u00020\u00112\u0006\u0010\\\u001a\u00020\u0013H\u0086 J\f\u0010c\u001a\u00020\u0015*\u00020dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/bugsnag/android/ndk/NativeBridge;", "Lcom/bugsnag/android/internal/StateObserver;", "bgTaskService", "Lcom/bugsnag/android/internal/BackgroundTaskService;", "(Lcom/bugsnag/android/internal/BackgroundTaskService;)V", "installed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "is32bit", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lcom/bugsnag/android/Logger;", "reportDirectory", "Ljava/io/File;", "addBreadcrumb", "", "name", "", "type", "", "timestamp", "metadata", "", "addFeatureFlag", "variant", "addHandledEvent", "addMetadataBoolean", "tab", "key", "value", "addMetadataDouble", "", "addMetadataOpaque", "addMetadataString", "addUnhandledEvent", "clearFeatureFlag", "clearFeatureFlags", "clearMetadataTab", "deliverPendingReports", "getCurrentCallbackSetCounts", "", "getCurrentNativeApiCallUsage", "getSignalUnwindStackFunction", "", "handleAddMetadata", "arg", "Lcom/bugsnag/android/StateEvent$AddMetadata;", "handleInstallMessage", "Lcom/bugsnag/android/StateEvent$Install;", "initCallbackCounts", "counts", "install", "apiKey", "reportingDirectory", "lastRunInfoPath", "eventUUID", "consecutiveLaunchCrashes", "autoDetectNdkCrashes", "apiLevel", "threadSendPolicy", "maxBreadcrumbs", "isInvalidMessage", "msg", "notifyAddCallback", "callback", "notifyRemoveCallback", "onStateChange", "event", "Lcom/bugsnag/android/StateEvent;", "pausedSession", "refreshSymbolTable", "removeMetadata", "setInternalMetricsEnabled", "enabled", "setStaticJsonData", "data", "startedSession", "sessionID", "handledCount", "unhandledCount", "updateContext", "context", "updateGroupingDiscriminator", "groupingDiscriminator", "updateInForeground", "inForeground", "activityName", "updateIsLaunching", "isLaunching", "updateLowMemory", "newValue", "memoryTrimLevelDescription", "updateOrientation", "orientation", "updateUserEmail", "updateUserId", "updateUserName", "toNativeValue", "Lcom/bugsnag/android/BreadcrumbType;", "bugsnag-plugin-android-ndk_release"})
@SourceDebugExtension(value={"SMAP\nNativeBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeBridge.kt\ncom/bugsnag/android/ndk/NativeBridge\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n12474#2,2:253\n13309#2,2:256\n1#3:255\n*S KotlinDebug\n*F\n+ 1 NativeBridge.kt\ncom/bugsnag/android/ndk/NativeBridge\n*L\n44#1:253,2\n181#1:256,2\n*E\n"})
public final class NativeBridge
implements StateObserver {
    @NotNull
    private final BackgroundTaskService bgTaskService;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final AtomicBoolean installed;
    @NotNull
    private final File reportDirectory;
    @NotNull
    private final Logger logger;

    public NativeBridge(@NotNull BackgroundTaskService bgTaskService) {
        this.bgTaskService = bgTaskService;
        this.lock = new ReentrantLock();
        this.installed = new AtomicBoolean(false);
        this.reportDirectory = NativeInterface.getNativeReportPath();
        this.logger = NativeInterface.getLogger();
    }

    private final boolean is32bit() {
        boolean bl;
        block1: {
            String[] abis;
            String[] $this$any$iv = abis = NativeInterface.getCpuAbi();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"64", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    public final native void install(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, int var5, boolean var6, int var7, boolean var8, int var9, int var10);

    public final native void startedSession(@NotNull String var1, @NotNull String var2, int var3, int var4);

    public final void addBreadcrumb(@NotNull String name, @NotNull String type, @NotNull String timestamp, @NotNull Object metadata) {
        BreadcrumbType breadcrumbType;
        BreadcrumbType breadcrumbType2;
        block2: {
            BreadcrumbType[] breadcrumbTypeArray = BreadcrumbType.values();
            int n = breadcrumbTypeArray.length;
            for (int i = 0; i < n; ++i) {
                BreadcrumbType breadcrumbType3;
                BreadcrumbType it = breadcrumbType3 = breadcrumbTypeArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.toString(), (Object)type)) continue;
                breadcrumbType2 = breadcrumbType3;
                break block2;
            }
            breadcrumbType2 = breadcrumbType = null;
        }
        if (breadcrumbType2 == null) {
            breadcrumbType = BreadcrumbType.MANUAL;
        }
        BreadcrumbType breadcrumbType4 = breadcrumbType;
        this.addBreadcrumb(name, this.toNativeValue(breadcrumbType4), timestamp, metadata);
    }

    private final native void addBreadcrumb(String var1, int var2, String var3, Object var4);

    public final native void addMetadataString(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public final native void addMetadataDouble(@NotNull String var1, @NotNull String var2, double var3);

    public final native void addMetadataBoolean(@NotNull String var1, @NotNull String var2, boolean var3);

    public final native void addMetadataOpaque(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public final native void addHandledEvent();

    public final native void addUnhandledEvent();

    public final native void clearMetadataTab(@NotNull String var1);

    public final native void removeMetadata(@NotNull String var1, @NotNull String var2);

    public final native void pausedSession();

    public final native void updateContext(@NotNull String var1);

    public final native void updateGroupingDiscriminator(@Nullable String var1);

    public final native void updateInForeground(boolean var1, @NotNull String var2);

    public final native void updateIsLaunching(boolean var1);

    public final native void updateOrientation(@NotNull String var1);

    public final native void updateUserId(@NotNull String var1);

    public final native void updateUserEmail(@NotNull String var1);

    public final native void updateUserName(@NotNull String var1);

    public final native void updateLowMemory(boolean var1, @NotNull String var2);

    public final native long getSignalUnwindStackFunction();

    public final native void addFeatureFlag(@NotNull String var1, @Nullable String var2);

    public final native void clearFeatureFlag(@NotNull String var1);

    public final native void clearFeatureFlags();

    public final native void refreshSymbolTable();

    public final native void initCallbackCounts(@NotNull Map<String, Integer> var1);

    public final native void notifyAddCallback(@NotNull String var1);

    public final native void notifyRemoveCallback(@NotNull String var1);

    @Nullable
    public final native Map<String, Integer> getCurrentCallbackSetCounts();

    @Nullable
    public final native Map<String, Boolean> getCurrentNativeApiCallUsage();

    public final native void setStaticJsonData(@NotNull String var1);

    public final native void setInternalMetricsEnabled(boolean var1);

    public void onStateChange(@NotNull StateEvent event) {
        if (this.isInvalidMessage(event)) {
            return;
        }
        StateEvent stateEvent = event;
        if (stateEvent instanceof StateEvent.Install) {
            this.handleInstallMessage((StateEvent.Install)event);
        } else if (stateEvent instanceof StateEvent.DeliverPending) {
            this.deliverPendingReports();
        } else if (stateEvent instanceof StateEvent.AddMetadata) {
            this.handleAddMetadata((StateEvent.AddMetadata)event);
        } else if (stateEvent instanceof StateEvent.ClearMetadataSection) {
            this.clearMetadataTab(((StateEvent.ClearMetadataSection)event).section);
        } else if (stateEvent instanceof StateEvent.ClearMetadataValue) {
            String string = ((StateEvent.ClearMetadataValue)event).section;
            String string2 = ((StateEvent.ClearMetadataValue)event).key;
            if (string2 == null) {
                string2 = "";
            }
            this.removeMetadata(string, string2);
        } else if (stateEvent instanceof StateEvent.AddBreadcrumb) {
            this.addBreadcrumb(((StateEvent.AddBreadcrumb)event).message, this.toNativeValue(((StateEvent.AddBreadcrumb)event).type), ((StateEvent.AddBreadcrumb)event).timestamp, (Object)((StateEvent.AddBreadcrumb)event).metadata);
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.NotifyHandled.INSTANCE)) {
            this.addHandledEvent();
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.NotifyUnhandled.INSTANCE)) {
            this.addUnhandledEvent();
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.PauseSession.INSTANCE)) {
            this.pausedSession();
        } else if (stateEvent instanceof StateEvent.StartSession) {
            this.startedSession(((StateEvent.StartSession)event).id, ((StateEvent.StartSession)event).startedAt, ((StateEvent.StartSession)event).handledCount, ((StateEvent.StartSession)event).getUnhandledCount());
        } else if (stateEvent instanceof StateEvent.UpdateContext) {
            String string = ((StateEvent.UpdateContext)event).context;
            if (string == null) {
                string = "";
            }
            this.updateContext(string);
        } else if (stateEvent instanceof StateEvent.UpdateGroupingDiscriminator) {
            this.updateGroupingDiscriminator(((StateEvent.UpdateGroupingDiscriminator)event).groupingDiscriminator);
        } else if (stateEvent instanceof StateEvent.UpdateInForeground) {
            boolean bl = ((StateEvent.UpdateInForeground)event).inForeground;
            String string = ((StateEvent.UpdateInForeground)event).getContextActivity();
            if (string == null) {
                string = "";
            }
            this.updateInForeground(bl, string);
        } else if (stateEvent instanceof StateEvent.UpdateIsLaunching) {
            this.updateIsLaunching(((StateEvent.UpdateIsLaunching)event).isLaunching);
            if (!((StateEvent.UpdateIsLaunching)event).isLaunching) {
                this.bgTaskService.submitTask(TaskType.DEFAULT, this::refreshSymbolTable);
            }
        } else if (stateEvent instanceof StateEvent.UpdateOrientation) {
            String string = ((StateEvent.UpdateOrientation)event).orientation;
            if (string == null) {
                string = "";
            }
            this.updateOrientation(string);
        } else if (stateEvent instanceof StateEvent.UpdateUser) {
            String string = ((StateEvent.UpdateUser)event).user.getId();
            if (string == null) {
                string = "";
            }
            this.updateUserId(string);
            String string3 = ((StateEvent.UpdateUser)event).user.getName();
            if (string3 == null) {
                string3 = "";
            }
            this.updateUserName(string3);
            String string4 = ((StateEvent.UpdateUser)event).user.getEmail();
            if (string4 == null) {
                string4 = "";
            }
            this.updateUserEmail(string4);
        } else if (stateEvent instanceof StateEvent.UpdateMemoryTrimEvent) {
            this.updateLowMemory(((StateEvent.UpdateMemoryTrimEvent)event).isLowMemory, ((StateEvent.UpdateMemoryTrimEvent)event).memoryTrimLevelDescription);
        } else if (stateEvent instanceof StateEvent.AddFeatureFlag) {
            this.addFeatureFlag(((StateEvent.AddFeatureFlag)event).name, ((StateEvent.AddFeatureFlag)event).variant);
        } else if (stateEvent instanceof StateEvent.ClearFeatureFlag) {
            this.clearFeatureFlag(((StateEvent.ClearFeatureFlag)event).name);
        } else if (stateEvent instanceof StateEvent.ClearFeatureFlags) {
            this.clearFeatureFlags();
        }
    }

    private final void deliverPendingReports() {
        block2: {
            ReportDiscardScanner discardScanner = new ReportDiscardScanner(this.logger, null, 2, null);
            File[] fileArray = this.reportDirectory.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File reportFile = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (discardScanner.shouldDiscard(reportFile)) {
                    reportFile.delete();
                    continue;
                }
                NativeInterface.deliverReport((File)reportFile);
            }
        }
    }

    private final boolean isInvalidMessage(Object msg) {
        if (msg == null || !(msg instanceof StateEvent)) {
            return true;
        }
        if (!this.installed.get() && !(msg instanceof StateEvent.Install)) {
            this.logger.w("Received message before INSTALL: " + msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInstallMessage(StateEvent.Install arg) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.installed.get()) {
                this.logger.w("Received duplicate setup message with arg: " + arg);
            } else {
                this.install(arg.apiKey, this.reportDirectory.getAbsolutePath(), arg.lastRunInfoPath, UUID.randomUUID().toString(), arg.consecutiveLaunchCrashes, arg.autoDetectNdkCrashes, Build.VERSION.SDK_INT, this.is32bit(), arg.sendThreads.ordinal(), arg.maxBreadcrumbs);
                this.installed.set(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void handleAddMetadata(StateEvent.AddMetadata arg) {
        block0: {
            Object newValue;
            block3: {
                block2: {
                    block1: {
                        if (arg.key == null) break block0;
                        newValue = OpaqueValue.Companion.makeSafe(arg.value);
                        if (!(newValue instanceof String)) break block1;
                        String string = arg.section;
                        String string2 = arg.key;
                        Intrinsics.checkNotNull((Object)string2);
                        this.addMetadataString(string, string2, (String)newValue);
                        break block0;
                    }
                    if (!(newValue instanceof Boolean)) break block2;
                    String string = arg.section;
                    String string3 = arg.key;
                    Intrinsics.checkNotNull((Object)string3);
                    this.addMetadataBoolean(string, string3, (Boolean)newValue);
                    break block0;
                }
                if (!(newValue instanceof Number)) break block3;
                String string = arg.section;
                String string4 = arg.key;
                Intrinsics.checkNotNull((Object)string4);
                this.addMetadataDouble(string, string4, ((Number)newValue).doubleValue());
                break block0;
            }
            if (!(newValue instanceof OpaqueValue)) break block0;
            String string = arg.section;
            String string5 = arg.key;
            Intrinsics.checkNotNull((Object)string5);
            this.addMetadataOpaque(string, string5, ((OpaqueValue)newValue).getJson());
        }
    }

    private final int toNativeValue(BreadcrumbType $this$toNativeValue) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toNativeValue.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BreadcrumbType.values().length];
            try {
                nArray[BreadcrumbType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.LOG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.MANUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.NAVIGATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.PROCESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.REQUEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.STATE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreadcrumbType.USER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

