/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Logger;
import java.util.HashMap;
import java.util.Map;

class AppData {
    private static final long startTimeMs = SystemClock.elapsedRealtime();
    static final String RELEASE_STAGE_DEVELOPMENT = "development";
    static final String RELEASE_STAGE_PRODUCTION = "production";
    private final Client client;
    private final Context appContext;
    private final String packageName;
    @Nullable
    final String appName;
    @Nullable
    private PackageInfo packageInfo;
    @Nullable
    private ApplicationInfo applicationInfo;
    @Nullable
    private PackageManager packageManager;

    AppData(Client client) {
        this.client = client;
        this.appContext = client.appContext;
        this.packageName = this.appContext.getPackageName();
        try {
            this.packageManager = this.appContext.getPackageManager();
            this.packageInfo = this.packageManager.getPackageInfo(this.packageName, 0);
            this.applicationInfo = this.packageManager.getApplicationInfo(this.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException exception) {
            Logger.warn("Could not retrieve package/application information for " + this.packageName);
        }
        this.appName = this.getAppName();
    }

    Map<String, Object> getAppDataSummary() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Configuration config = this.client.config;
        map.put("type", this.calculateNotifierType(config));
        map.put("releaseStage", this.guessReleaseStage());
        map.put("version", this.calculateVersionName());
        map.put("versionCode", this.calculateVersionCode());
        map.put("codeBundleId", config.getCodeBundleId());
        return map;
    }

    Map<String, Object> getAppData() {
        Map<String, Object> map = this.getAppDataSummary();
        map.put("id", this.packageName);
        map.put("buildUUID", this.client.config.getBuildUUID());
        map.put("duration", AppData.getDurationMs());
        map.put("durationInForeground", this.calculateDurationInForeground());
        map.put("inForeground", this.client.sessionTracker.isInForeground());
        map.put("packageName", this.packageName);
        return map;
    }

    Map<String, Object> getAppDataMetaData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.appName);
        map.put("packageName", this.packageName);
        map.put("versionName", this.calculateVersionName());
        map.put("activeScreen", this.getActiveScreenClass());
        map.put("memoryUsage", this.getMemoryUsage());
        map.put("lowMemory", this.isLowMemory());
        return map;
    }

    static long getDurationMs() {
        return SystemClock.elapsedRealtime() - startTimeMs;
    }

    private long calculateDurationInForeground() {
        long nowMs = System.currentTimeMillis();
        return this.client.sessionTracker.getDurationInForegroundMs(nowMs);
    }

    String getActiveScreenClass() {
        return this.client.sessionTracker.getContextActivity();
    }

    @NonNull
    private String calculateNotifierType(Configuration config) {
        String notifierType = config.getNotifierType();
        if (notifierType != null) {
            return notifierType;
        }
        return "android";
    }

    @Nullable
    private Integer calculateVersionCode() {
        if (this.packageInfo != null) {
            return this.packageInfo.versionCode;
        }
        return null;
    }

    @Nullable
    private String calculateVersionName() {
        String configAppVersion = this.client.config.getAppVersion();
        if (configAppVersion != null) {
            return configAppVersion;
        }
        if (this.packageInfo != null) {
            return this.packageInfo.versionName;
        }
        return null;
    }

    @NonNull
    String guessReleaseStage() {
        String configStage = this.client.config.getReleaseStage();
        if (configStage != null) {
            return configStage;
        }
        if (this.applicationInfo != null && (this.applicationInfo.flags & 2) != 0) {
            return RELEASE_STAGE_DEVELOPMENT;
        }
        return RELEASE_STAGE_PRODUCTION;
    }

    @Nullable
    private String getAppName() {
        if (this.packageManager != null && this.applicationInfo != null) {
            return this.packageManager.getApplicationLabel(this.applicationInfo).toString();
        }
        return null;
    }

    private long getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    @Nullable
    private Boolean isLowMemory() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            if (activityManager != null) {
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                activityManager.getMemoryInfo(memInfo);
                return memInfo.lowMemory;
            }
        }
        catch (Exception exception) {
            Logger.warn("Could not check lowMemory status");
        }
        return null;
    }
}

