/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

class ThreadState
implements JsonStream.Streamable {
    private static final String THREAD_TYPE = "android";
    private final Configuration config;
    private final Thread[] threads;
    private final Map<Thread, StackTraceElement[]> stackTraces;
    private final long currentThreadId;

    public ThreadState(@NonNull Configuration config, @NonNull Thread currentThread, @NonNull Map<Thread, StackTraceElement[]> allStackTraces, @Nullable Throwable exc) {
        this.config = config;
        this.stackTraces = allStackTraces;
        if (!this.stackTraces.containsKey(currentThread)) {
            this.stackTraces.put(currentThread, currentThread.getStackTrace());
        }
        if (exc != null) {
            this.stackTraces.put(currentThread, exc.getStackTrace());
        }
        this.currentThreadId = currentThread.getId();
        this.threads = this.sanitiseThreads(this.stackTraces);
    }

    private Thread[] sanitiseThreads(Map<Thread, StackTraceElement[]> liveThreads) {
        Set<Thread> threadSet = liveThreads.keySet();
        Thread[] threads = threadSet.toArray(new Thread[threadSet.size()]);
        Arrays.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(@NonNull Thread lhs, @NonNull Thread rhs) {
                return Long.valueOf(lhs.getId()).compareTo(rhs.getId());
            }
        });
        return threads;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Thread thread : this.threads) {
            writer.beginObject();
            writer.name("id").value(thread.getId());
            writer.name("name").value(thread.getName());
            writer.name("type").value(THREAD_TYPE);
            StackTraceElement[] stacktrace = this.stackTraces.get(thread);
            writer.name("stacktrace").value(new Stacktrace(this.config, stacktrace));
            if (this.currentThreadId == thread.getId()) {
                writer.name("errorReportingThread").value(true);
            }
            writer.endObject();
        }
        writer.endArray();
    }
}

