/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.AppData;
import com.bugsnag.android.DeviceDataSummary;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.Session;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SessionTrackingPayload
implements JsonStream.Streamable {
    private final Notifier notifier;
    private final Session session;
    private final DeviceDataSummary deviceDataSummary = new DeviceDataSummary();
    private final AppData appData;
    private final List<File> files;

    SessionTrackingPayload(List<File> files, AppData appData) {
        this.appData = appData;
        this.notifier = Notifier.getInstance();
        this.session = null;
        this.files = files;
    }

    SessionTrackingPayload(Session session, AppData appDataSummary) {
        this.appData = appDataSummary;
        this.notifier = Notifier.getInstance();
        this.session = session;
        this.files = null;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("notifier").value(this.notifier);
        writer.name("app").value(this.appData);
        writer.name("device").value(this.deviceDataSummary);
        writer.name("sessions").beginArray();
        if (this.session == null) {
            for (File file : this.files) {
                writer.value(file);
            }
        } else {
            writer.value(this.session);
        }
        writer.endArray();
        writer.endObject();
    }
}

