/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bugsnag.android.AppData;
import com.bugsnag.android.Async;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.BeforeRecordBreadcrumb;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DefaultDelivery;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryCompat;
import com.bugsnag.android.DeliveryFailureException;
import com.bugsnag.android.DeliveryStyle;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.ErrorStore;
import com.bugsnag.android.EventReceiver;
import com.bugsnag.android.ExceptionHandler;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.NotifyType;
import com.bugsnag.android.Report;
import com.bugsnag.android.SessionStore;
import com.bugsnag.android.SessionTracker;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.Severity;
import com.bugsnag.android.User;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.RejectedExecutionException;

public class Client
extends Observable
implements Observer {
    private static final boolean BLOCKING = true;
    private static final String SHARED_PREF_KEY = "com.bugsnag.android";
    private static final String BUGSNAG_NAMESPACE = "com.bugsnag.android";
    private static final String USER_ID_KEY = "user.id";
    private static final String USER_NAME_KEY = "user.name";
    private static final String USER_EMAIL_KEY = "user.email";
    static final String MF_API_KEY = "com.bugsnag.android.API_KEY";
    static final String MF_BUILD_UUID = "com.bugsnag.android.BUILD_UUID";
    static final String MF_APP_VERSION = "com.bugsnag.android.APP_VERSION";
    static final String MF_ENDPOINT = "com.bugsnag.android.ENDPOINT";
    static final String MF_SESSIONS_ENDPOINT = "com.bugsnag.android.SESSIONS_ENDPOINT";
    static final String MF_RELEASE_STAGE = "com.bugsnag.android.RELEASE_STAGE";
    static final String MF_SEND_THREADS = "com.bugsnag.android.SEND_THREADS";
    static final String MF_ENABLE_EXCEPTION_HANDLER = "com.bugsnag.android.ENABLE_EXCEPTION_HANDLER";
    static final String MF_PERSIST_USER_BETWEEN_SESSIONS = "com.bugsnag.android.PERSIST_USER_BETWEEN_SESSIONS";
    static final String MF_AUTO_CAPTURE_SESSIONS = "com.bugsnag.android.AUTO_CAPTURE_SESSIONS";
    @NonNull
    protected final Configuration config;
    private final Context appContext;
    @NonNull
    protected final AppData appData;
    @NonNull
    protected final DeviceData deviceData;
    @NonNull
    final Breadcrumbs breadcrumbs;
    protected final User user = new User();
    @NonNull
    protected final ErrorStore errorStore;
    final SessionStore sessionStore;
    private final EventReceiver eventReceiver;
    final SessionTracker sessionTracker;

    public Client(@NonNull Context androidContext) {
        this(androidContext, null, true);
    }

    public Client(@NonNull Context androidContext, @Nullable String apiKey) {
        this(androidContext, apiKey, true);
    }

    public Client(@NonNull Context androidContext, @Nullable String apiKey, boolean enableExceptionHandler) {
        this(androidContext, Client.createNewConfiguration(androidContext, apiKey, enableExceptionHandler));
    }

    public Client(@NonNull Context androidContext, @NonNull Configuration configuration) {
        Client.warnIfNotAppContext(androidContext);
        this.appContext = androidContext.getApplicationContext();
        this.config = configuration;
        this.sessionStore = new SessionStore(this.config, this.appContext);
        ConnectivityManager cm = (ConnectivityManager)this.appContext.getSystemService("connectivity");
        if (configuration.getDelivery() == null) {
            configuration.setDelivery(new DefaultDelivery(cm));
        }
        this.sessionTracker = new SessionTracker(configuration, this, this.sessionStore);
        this.eventReceiver = new EventReceiver(this);
        SharedPreferences sharedPref = this.appContext.getSharedPreferences("com.bugsnag.android", 0);
        this.appData = new AppData(this.appContext, this.config, this.sessionTracker);
        this.deviceData = new DeviceData(this.appContext, sharedPref);
        this.breadcrumbs = new Breadcrumbs();
        this.setProjectPackages(this.appContext.getPackageName());
        if (this.config.getPersistUserBetweenSessions()) {
            this.user.setId(sharedPref.getString(USER_ID_KEY, this.deviceData.getUserId()));
            this.user.setName(sharedPref.getString(USER_NAME_KEY, null));
            this.user.setEmail(sharedPref.getString(USER_EMAIL_KEY, null));
        } else {
            this.user.setId(this.deviceData.getUserId());
        }
        if (this.appContext instanceof Application) {
            Application application = (Application)this.appContext;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.sessionTracker);
        } else {
            Logger.warn("Bugsnag is unable to setup automatic activity lifecycle breadcrumbs on API Levels below 14.");
        }
        if (this.config.getBuildUUID() == null) {
            String buildUuid = null;
            try {
                PackageManager packageManager = this.appContext.getPackageManager();
                String packageName = this.appContext.getPackageName();
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
                buildUuid = ai.metaData.getString(MF_BUILD_UUID);
            }
            catch (Exception ignore) {
                Logger.warn("Bugsnag is unable to read build UUID from manifest.");
            }
            if (buildUuid != null) {
                this.config.setBuildUUID(buildUuid);
            }
        }
        this.errorStore = new ErrorStore(this.config, this.appContext);
        if (this.config.getEnableExceptionHandler()) {
            this.enableExceptionHandler();
        }
        try {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    Client.this.appContext.registerReceiver((BroadcastReceiver)Client.this.eventReceiver, EventReceiver.getIntentFilter());
                    Client.this.appContext.registerReceiver((BroadcastReceiver)new ConnectivityChangeReceiver(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Logger.warn("Failed to register for automatic breadcrumb broadcasts", ex);
        }
        this.config.addObserver(this);
        boolean isNotProduction = !"production".equals(AppData.guessReleaseStage(this.appContext));
        Logger.setEnabled(isNotProduction);
        this.errorStore.flushOnLaunch();
    }

    public void notifyBugsnagObservers(@NonNull NotifyType type) {
        this.setChanged();
        super.notifyObservers(type.getValue());
    }

    @Override
    public void update(Observable observable, Object arg) {
        NotifyType type;
        if (arg instanceof Integer && (type = NotifyType.fromInt((Integer)arg)) != null) {
            this.notifyBugsnagObservers(type);
        }
    }

    @NonNull
    private static Configuration createNewConfiguration(@NonNull Context androidContext, String apiKey, boolean enableExceptionHandler) {
        Context appContext = androidContext.getApplicationContext();
        boolean loadFromManifest = TextUtils.isEmpty((CharSequence)apiKey);
        if (loadFromManifest) {
            try {
                PackageManager packageManager = appContext.getPackageManager();
                String packageName = appContext.getPackageName();
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
                Bundle data = ai.metaData;
                apiKey = data.getString(MF_API_KEY);
            }
            catch (Exception ignore) {
                Logger.warn("Bugsnag is unable to read api key from manifest.");
            }
        }
        if (apiKey == null) {
            throw new NullPointerException("You must provide a Bugsnag API key");
        }
        Configuration newConfig = new Configuration(apiKey);
        newConfig.setEnableExceptionHandler(enableExceptionHandler);
        if (loadFromManifest) {
            try {
                PackageManager packageManager = appContext.getPackageManager();
                String packageName = appContext.getPackageName();
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
                Bundle data = ai.metaData;
                Client.populateConfigFromManifest(newConfig, data);
            }
            catch (Exception ignore) {
                Logger.warn("Bugsnag is unable to read config from manifest.");
            }
        }
        return newConfig;
    }

    @NonNull
    static Configuration populateConfigFromManifest(@NonNull Configuration config, @NonNull Bundle data) {
        config.setBuildUUID(data.getString(MF_BUILD_UUID));
        config.setAppVersion(data.getString(MF_APP_VERSION));
        config.setReleaseStage(data.getString(MF_RELEASE_STAGE));
        if (data.containsKey(MF_ENDPOINT)) {
            String endpoint = data.getString(MF_ENDPOINT);
            String sessionEndpoint = data.getString(MF_SESSIONS_ENDPOINT);
            config.setEndpoints(endpoint, sessionEndpoint);
        }
        config.setSendThreads(data.getBoolean(MF_SEND_THREADS, true));
        config.setPersistUserBetweenSessions(data.getBoolean(MF_PERSIST_USER_BETWEEN_SESSIONS, false));
        if (data.containsKey(MF_AUTO_CAPTURE_SESSIONS)) {
            config.setAutoCaptureSessions(data.getBoolean(MF_AUTO_CAPTURE_SESSIONS));
        }
        config.setEnableExceptionHandler(data.getBoolean(MF_ENABLE_EXCEPTION_HANDLER, true));
        return config;
    }

    public void startSession() {
        this.sessionTracker.startNewSession(new Date(), this.user, false);
    }

    public void startFirstSession(Activity activity) {
        this.sessionTracker.startFirstSession(activity);
    }

    public void setAppVersion(String appVersion) {
        this.config.setAppVersion(appVersion);
    }

    public String getContext() {
        return this.config.getContext();
    }

    public void setContext(String context) {
        this.config.setContext(context);
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        this.config.setEndpoint(endpoint);
    }

    public void setBuildUUID(String buildUuid) {
        this.config.setBuildUUID(buildUuid);
    }

    public void setFilters(String ... filters) {
        this.config.setFilters(filters);
    }

    public void setIgnoreClasses(String ... ignoreClasses) {
        this.config.setIgnoreClasses(ignoreClasses);
    }

    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        this.config.setNotifyReleaseStages(notifyReleaseStages);
    }

    public void setProjectPackages(String ... projectPackages) {
        this.config.setProjectPackages(projectPackages);
    }

    public void setReleaseStage(String releaseStage) {
        this.config.setReleaseStage(releaseStage);
        Logger.setEnabled(!"production".equals(releaseStage));
    }

    public void setSendThreads(boolean sendThreads) {
        this.config.setSendThreads(sendThreads);
    }

    public void setAutoCaptureSessions(boolean autoCapture) {
        this.config.setAutoCaptureSessions(autoCapture);
        if (autoCapture) {
            this.sessionTracker.onAutoCaptureEnabled();
        }
    }

    public void setUser(String id, String email, String name) {
        this.setUserId(id);
        this.setUserEmail(email);
        this.setUserName(name);
    }

    public void clearUser() {
        this.user.setId(this.deviceData.getUserId());
        this.user.setEmail(null);
        this.user.setName(null);
        SharedPreferences sharedPref = this.appContext.getSharedPreferences("com.bugsnag.android", 0);
        sharedPref.edit().remove(USER_ID_KEY).remove(USER_EMAIL_KEY).remove(USER_NAME_KEY).apply();
        this.notifyBugsnagObservers(NotifyType.USER);
    }

    public void setUserId(String id) {
        this.setUserId(id, true);
    }

    void setUserId(String id, boolean notify) {
        this.user.setId(id);
        if (this.config.getPersistUserBetweenSessions()) {
            this.storeInSharedPrefs(USER_ID_KEY, id);
        }
        if (notify) {
            this.notifyBugsnagObservers(NotifyType.USER);
        }
    }

    public void setUserEmail(String email) {
        this.setUserEmail(email, true);
    }

    void setUserEmail(String email, boolean notify) {
        this.user.setEmail(email);
        if (this.config.getPersistUserBetweenSessions()) {
            this.storeInSharedPrefs(USER_EMAIL_KEY, email);
        }
        if (notify) {
            this.notifyBugsnagObservers(NotifyType.USER);
        }
    }

    public void setUserName(String name) {
        this.setUserName(name, true);
    }

    void setUserName(String name, boolean notify) {
        this.user.setName(name);
        if (this.config.getPersistUserBetweenSessions()) {
            this.storeInSharedPrefs(USER_NAME_KEY, name);
        }
        if (notify) {
            this.notifyBugsnagObservers(NotifyType.USER);
        }
    }

    DeliveryCompat getAndSetDeliveryCompat() {
        Delivery current = this.config.getDelivery();
        if (current instanceof DeliveryCompat) {
            return (DeliveryCompat)current;
        }
        DeliveryCompat compat = new DeliveryCompat();
        this.config.setDelivery(compat);
        return compat;
    }

    @Deprecated
    void setErrorReportApiClient(@NonNull ErrorReportApiClient errorReportApiClient) {
        if (errorReportApiClient == null) {
            throw new IllegalArgumentException("ErrorReportApiClient cannot be null.");
        }
        DeliveryCompat compat = this.getAndSetDeliveryCompat();
        compat.errorReportApiClient = errorReportApiClient;
    }

    @Deprecated
    void setSessionTrackingApiClient(@NonNull SessionTrackingApiClient apiClient) {
        if (apiClient == null) {
            throw new IllegalArgumentException("SessionTrackingApiClient cannot be null.");
        }
        DeliveryCompat compat = this.getAndSetDeliveryCompat();
        compat.sessionTrackingApiClient = apiClient;
    }

    public void beforeNotify(BeforeNotify beforeNotify) {
        this.config.beforeNotify(beforeNotify);
    }

    public void beforeRecordBreadcrumb(BeforeRecordBreadcrumb beforeRecordBreadcrumb) {
        this.config.beforeRecordBreadcrumb(beforeRecordBreadcrumb);
    }

    public void notify(@NonNull Throwable exception) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").build();
        this.notify(error, false);
    }

    public void notify(@NonNull Throwable exception, Callback callback) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").build();
        this.notify(error, DeliveryStyle.ASYNC, callback);
    }

    public void notify(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, Callback callback) {
        Error error = new Error.Builder(this.config, name, message, stacktrace, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").build();
        this.notify(error, DeliveryStyle.ASYNC, callback);
    }

    public void notify(@NonNull Throwable exception, Severity severity) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severity(severity).build();
        this.notify(error, false);
    }

    public void notify(@NonNull Throwable exception, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).metaData(metaData).severityReasonType("handledException").build();
        this.notify(error, false);
    }

    @Deprecated
    public void notify(@NonNull Throwable exception, Severity severity, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).metaData(metaData).severity(severity).build();
        this.notify(error, false);
    }

    @Deprecated
    public void notify(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, Severity severity, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, name, message, stacktrace, this.sessionTracker.getCurrentSession()).severity(severity).metaData(metaData).build();
        this.notify(error, false);
    }

    @Deprecated
    public void notify(@NonNull String name, @NonNull String message, String context, @NonNull StackTraceElement[] stacktrace, Severity severity, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, name, message, stacktrace, this.sessionTracker.getCurrentSession()).severity(severity).metaData(metaData).build();
        error.setContext(context);
        this.notify(error, false);
    }

    private void notify(@NonNull Error error, boolean blocking) {
        DeliveryStyle style = blocking ? DeliveryStyle.SAME_THREAD : DeliveryStyle.ASYNC;
        this.notify(error, style, null);
    }

    void notify(@NonNull Error error, @NonNull DeliveryStyle style, @Nullable Callback callback) {
        HandledState handledState;
        if (error.shouldIgnoreClass()) {
            return;
        }
        if (!this.config.shouldNotifyForReleaseStage(this.appData.getReleaseStage())) {
            return;
        }
        error.setAppData(this.appData);
        error.setDeviceData(this.deviceData);
        error.setBreadcrumbs(this.breadcrumbs);
        error.setUser(this.user);
        if (!this.runBeforeNotifyTasks(error)) {
            Logger.info("Skipping notification - beforeNotify task returned false");
            return;
        }
        Report report = new Report(this.config.getApiKey(), error);
        if (callback != null) {
            callback.beforeNotify(report);
        }
        if ((handledState = report.getError().getHandledState()).isUnhandled()) {
            this.sessionTracker.incrementUnhandledError();
        } else {
            this.sessionTracker.incrementHandledError();
        }
        switch (style) {
            case SAME_THREAD: {
                this.deliver(report, error);
                break;
            }
            case ASYNC: {
                final Report finalReport = report;
                final Error finalError = error;
                try {
                    Async.run(new Runnable(){

                        @Override
                        public void run() {
                            Client.this.deliver(finalReport, finalError);
                        }
                    });
                }
                catch (RejectedExecutionException exception) {
                    this.errorStore.write(error);
                    Logger.warn("Exceeded max queue count, saving to disk to send later");
                }
                break;
            }
            case ASYNC_WITH_CACHE: {
                this.errorStore.write(error);
                this.errorStore.flushAsync();
                break;
            }
        }
        String exceptionMessage = error.getExceptionMessage();
        Map<String, String> message = Collections.singletonMap("message", exceptionMessage);
        this.breadcrumbs.add(new Breadcrumb(error.getExceptionName(), BreadcrumbType.ERROR, message));
    }

    public void notifyBlocking(@NonNull Throwable exception) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").build();
        this.notify(error, true);
    }

    public void notifyBlocking(@NonNull Throwable exception, Callback callback) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").build();
        this.notify(error, DeliveryStyle.SAME_THREAD, callback);
    }

    public void notifyBlocking(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, Callback callback) {
        Error error = new Error.Builder(this.config, name, message, stacktrace, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").build();
        this.notify(error, DeliveryStyle.SAME_THREAD, callback);
    }

    public void notifyBlocking(@NonNull Throwable exception, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severityReasonType("handledException").metaData(metaData).build();
        this.notify(error, true);
    }

    @Deprecated
    public void notifyBlocking(@NonNull Throwable exception, Severity severity, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).metaData(metaData).severity(severity).build();
        this.notify(error, true);
    }

    @Deprecated
    public void notifyBlocking(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, Severity severity, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, name, message, stacktrace, this.sessionTracker.getCurrentSession()).severity(severity).metaData(metaData).build();
        this.notify(error, true);
    }

    @Deprecated
    public void notifyBlocking(@NonNull String name, @NonNull String message, String context, @NonNull StackTraceElement[] stacktrace, Severity severity, @NonNull MetaData metaData) {
        Error error = new Error.Builder(this.config, name, message, stacktrace, this.sessionTracker.getCurrentSession()).severity(severity).metaData(metaData).build();
        error.setContext(context);
        this.notify(error, true);
    }

    public void notifyBlocking(@NonNull Throwable exception, Severity severity) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severity(severity).build();
        this.notify(error, true);
    }

    public void internalClientNotify(@NonNull Throwable exception, Map<String, Object> clientData, boolean blocking, Callback callback) {
        String severity = this.getKeyFromClientData(clientData, "severity", true);
        String severityReason = this.getKeyFromClientData(clientData, "severityReason", true);
        String logLevel = this.getKeyFromClientData(clientData, "logLevel", false);
        String msg = String.format("Internal client notify, severity = '%s', severityReason = '%s'", severity, severityReason);
        Logger.info(msg);
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severity(Severity.fromString(severity)).severityReasonType(severityReason).attributeValue(logLevel).build();
        DeliveryStyle deliveryStyle = blocking ? DeliveryStyle.SAME_THREAD : DeliveryStyle.ASYNC;
        this.notify(error, deliveryStyle, callback);
    }

    @NonNull
    private String getKeyFromClientData(Map<String, Object> clientData, String key, boolean required) {
        Object value = clientData.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (required) {
            throw new IllegalStateException("Failed to set " + key + " in client data!");
        }
        return null;
    }

    public void addToTab(String tab, String key, Object value) {
        this.config.getMetaData().addToTab(tab, key, value);
    }

    public void clearTab(String tabName) {
        this.config.getMetaData().clearTab(tabName);
    }

    @NonNull
    public MetaData getMetaData() {
        return this.config.getMetaData();
    }

    public void setMetaData(@NonNull MetaData metaData) {
        this.config.setMetaData(metaData);
    }

    public void leaveBreadcrumb(@NonNull String breadcrumb) {
        Breadcrumb crumb = new Breadcrumb(breadcrumb);
        if (this.runBeforeBreadcrumbTasks(crumb)) {
            this.breadcrumbs.add(crumb);
            this.notifyBugsnagObservers(NotifyType.BREADCRUMB);
        }
    }

    public void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type, @NonNull Map<String, String> metadata) {
        this.leaveBreadcrumb(name, type, metadata, true);
    }

    void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type, @NonNull Map<String, String> metadata, boolean notify) {
        Breadcrumb crumb = new Breadcrumb(name, type, metadata);
        if (this.runBeforeBreadcrumbTasks(crumb)) {
            this.breadcrumbs.add(crumb);
            if (notify) {
                this.notifyBugsnagObservers(NotifyType.BREADCRUMB);
            }
        }
    }

    public void setMaxBreadcrumbs(int numBreadcrumbs) {
        this.breadcrumbs.setSize(numBreadcrumbs);
    }

    public void clearBreadcrumbs() {
        this.breadcrumbs.clear();
        this.notifyBugsnagObservers(NotifyType.BREADCRUMB);
    }

    public void enableExceptionHandler() {
        ExceptionHandler.enable(this);
    }

    public void disableExceptionHandler() {
        ExceptionHandler.disable(this);
    }

    void deliver(@NonNull Report report, @NonNull Error error) {
        try {
            this.config.getDelivery().deliver(report, this.config);
            Logger.info("Sent 1 new error to Bugsnag");
        }
        catch (DeliveryFailureException exception) {
            Logger.warn("Could not send error(s) to Bugsnag, saving to disk to send later", exception);
            this.errorStore.write(error);
        }
        catch (Exception exception) {
            Logger.warn("Problem sending error to Bugsnag", exception);
        }
    }

    void cacheAndNotify(@NonNull Throwable exception, Severity severity, MetaData metaData, String severityReason, @Nullable String attributeValue) {
        Error error = new Error.Builder(this.config, exception, this.sessionTracker.getCurrentSession()).severity(severity).metaData(metaData).severityReasonType(severityReason).attributeValue(attributeValue).build();
        this.notify(error, DeliveryStyle.ASYNC_WITH_CACHE, null);
    }

    private boolean runBeforeNotifyTasks(Error error) {
        for (BeforeNotify beforeNotify : this.config.getBeforeNotifyTasks()) {
            try {
                if (beforeNotify.run(error)) continue;
                return false;
            }
            catch (Throwable ex) {
                Logger.warn("BeforeNotify threw an Exception", ex);
            }
        }
        return true;
    }

    private boolean runBeforeBreadcrumbTasks(@NonNull Breadcrumb breadcrumb) {
        Collection<BeforeRecordBreadcrumb> tasks = this.config.getBeforeRecordBreadcrumbTasks();
        for (BeforeRecordBreadcrumb beforeRecordBreadcrumb : tasks) {
            try {
                if (beforeRecordBreadcrumb.shouldRecord(breadcrumb)) continue;
                return false;
            }
            catch (Throwable ex) {
                Logger.warn("BeforeRecordBreadcrumb threw an Exception", ex);
            }
        }
        return true;
    }

    private void storeInSharedPrefs(String key, String value) {
        SharedPreferences sharedPref = this.appContext.getSharedPreferences("com.bugsnag.android", 0);
        sharedPref.edit().putString(key, value).apply();
    }

    protected void finalize() throws Throwable {
        if (this.eventReceiver != null) {
            try {
                this.appContext.unregisterReceiver((BroadcastReceiver)this.eventReceiver);
            }
            catch (IllegalArgumentException exception) {
                Logger.warn("Receiver not registered");
            }
        }
        super.finalize();
    }

    private static void warnIfNotAppContext(Context androidContext) {
        if (!(androidContext instanceof Application)) {
            Logger.warn("Warning - Non-Application context detected! Please ensure that you are initializing Bugsnag from a custom Application class.");
        }
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        Logger.setEnabled(loggingEnabled);
    }

    @NonNull
    public Configuration getConfig() {
        return this.config;
    }

    public long getLaunchTimeMs() {
        return AppData.getDurationMs();
    }

    private class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        private ConnectivityChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            boolean retryReports;
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            boolean bl = retryReports = networkInfo != null && networkInfo.isConnectedOrConnecting();
            if (retryReports) {
                Client.this.errorStore.flushAsync();
            }
        }
    }
}

