/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryFailureException;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Report;
import com.bugsnag.android.SessionTrackingPayload;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

class DefaultDelivery
implements Delivery {
    private final ConnectivityManager connectivityManager;

    DefaultDelivery(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    @Override
    public void deliver(SessionTrackingPayload payload, Configuration config) throws DeliveryFailureException {
        String endpoint = config.getSessionEndpoint();
        int status = this.deliver(endpoint, payload, config.getSessionApiHeaders());
        if (status != 202) {
            Logger.warn("Session API request failed with status " + status, null);
        } else {
            Logger.info("Completed session tracking request");
        }
    }

    @Override
    public void deliver(Report report, Configuration config) throws DeliveryFailureException {
        String endpoint = config.getEndpoint();
        int status = this.deliver(endpoint, report, config.getErrorApiHeaders());
        if (status / 100 != 2) {
            Logger.warn("Error API request failed with status " + status, null);
        } else {
            Logger.info("Completed error API request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deliver(String urlString, JsonStream.Streamable streamable, Map<String, String> headers) throws DeliveryFailureException {
        int n;
        this.checkHasNetworkConnection();
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
            conn.addRequestProperty("Content-Type", "application/json");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
            JsonStream stream = null;
            try {
                OutputStream out = conn.getOutputStream();
                Charset charset = Charset.forName("UTF-8");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset));
                stream = new JsonStream(writer);
                streamable.toStream(stream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly(stream);
            n = conn.getResponseCode();
        }
        catch (IOException exception) {
            try {
                throw new DeliveryFailureException("IOException encountered in request", exception);
            }
            catch (Throwable throwable) {
                IOUtils.close(conn);
                throw throwable;
            }
        }
        IOUtils.close(conn);
        return n;
    }

    private void checkHasNetworkConnection() throws DeliveryFailureException {
        NetworkInfo activeNetworkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (activeNetworkInfo == null || !activeNetworkInfo.isConnectedOrConnecting()) {
            throw new DeliveryFailureException("No network connection available", null);
        }
    }
}

