/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class Breadcrumbs
implements JsonStream.Streamable {
    private static final int DEFAULT_MAX_SIZE = 32;
    private static final int MAX_PAYLOAD_SIZE = 4096;
    final Queue<Breadcrumb> store = new ConcurrentLinkedQueue<Breadcrumb>();
    private int maxSize = 32;

    Breadcrumbs() {
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Breadcrumb breadcrumb : this.store) {
            breadcrumb.toStream(writer);
        }
        writer.endArray();
    }

    void add(@NonNull Breadcrumb breadcrumb) {
        this.addToStore(breadcrumb);
    }

    void clear() {
        this.store.clear();
    }

    void setSize(int size) {
        if (size < 0) {
            Logger.warn("Ignoring invalid breadcrumb capacity. Must be >= 0.");
            return;
        }
        this.maxSize = size;
        while (this.store.size() > size) {
            this.store.poll();
        }
    }

    private void addToStore(@NonNull Breadcrumb breadcrumb) {
        try {
            if (breadcrumb.payloadSize() > 4096) {
                Logger.warn("Dropping breadcrumb because payload exceeds 4KB limit");
                return;
            }
            this.store.add(breadcrumb);
            if (this.store.size() > this.maxSize) {
                this.store.poll();
            }
        }
        catch (IOException ex) {
            Logger.warn("Dropping breadcrumb because it could not be serialized", ex);
        }
    }
}

