/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import java.io.File;
import java.io.IOException;

class DeviceDataSummary
implements JsonStream.Streamable {
    private final Boolean rooted = DeviceDataSummary.isRooted();
    private static final String[] ROOT_INDICATORS = new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/Superuser.apk", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/SuperSU", "/system/xbin/daemonsu", "/su/bin"};

    DeviceDataSummary() {
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        this.serialiseMinimalDeviceData(writer);
        writer.endObject();
    }

    void serialiseMinimalDeviceData(@NonNull JsonStream writer) throws IOException {
        writer.name("manufacturer").value(Build.MANUFACTURER).name("model").value(Build.MODEL).name("jailbroken").value(this.rooted).name("osName").value("android").name("osVersion").value(Build.VERSION.RELEASE);
    }

    @Nullable
    static Boolean isRooted() {
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        try {
            for (String candidate : ROOT_INDICATORS) {
                if (!new File(candidate).exists()) continue;
                return true;
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return false;
    }
}

