/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.support.annotation.NonNull;
import com.bugsnag.android.AppData;
import com.bugsnag.android.Async;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NetworkException;
import com.bugsnag.android.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;

class ErrorStore
extends FileStore<Error> {
    private static final String STARTUP_CRASH = "_startupcrash";
    private static final long LAUNCH_CRASH_TIMEOUT_MS = 2000L;
    private static final int LAUNCH_CRASH_POLL_MS = 50;
    private volatile boolean flushOnLaunchCompleted = false;
    static final Comparator<File> ERROR_REPORT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            String rhsName = rhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            return lhsName.compareTo(rhsName);
        }
    };

    ErrorStore(@NonNull Configuration config, @NonNull Context appContext) {
        super(config, appContext, "/bugsnag-errors/", 128, ERROR_REPORT_COMPARATOR);
    }

    void flushOnLaunch(final ErrorReportApiClient errorReportApiClient) {
        final List<File> crashReports = this.findLaunchCrashReports();
        if (crashReports.isEmpty() || this.config.getLaunchCrashThresholdMs() == 0L) {
            this.flushAsync(errorReportApiClient);
        } else {
            this.flushOnLaunchCompleted = false;
            Async.run(new Runnable(){

                @Override
                public void run() {
                    Logger.info("Attempting to send launch crash reports");
                    for (File crashReport : crashReports) {
                        ErrorStore.this.flushErrorReport(crashReport, errorReportApiClient);
                    }
                    Logger.info("Delivered all launch crash reports");
                    ErrorStore.this.flushOnLaunchCompleted = true;
                }
            });
            long waitMs = 0L;
            while (!this.flushOnLaunchCompleted && waitMs < 2000L) {
                try {
                    Thread.sleep(50L);
                    waitMs += 50L;
                }
                catch (InterruptedException e) {
                    Logger.warn("Interrupted while waiting for launch crash report request");
                }
            }
            Logger.info("Continuing with Bugsnag initialisation");
        }
    }

    void flushAsync(final ErrorReportApiClient errorReportApiClient) {
        if (this.storeDirectory == null) {
            return;
        }
        try {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    List<File> storedFiles = ErrorStore.this.findStoredFiles();
                    if (!storedFiles.isEmpty()) {
                        Logger.info(String.format(Locale.US, "Sending %d saved error(s) to Bugsnag", storedFiles.size()));
                        for (File errorFile : storedFiles) {
                            ErrorStore.this.flushErrorReport(errorFile, errorReportApiClient);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Logger.warn("Failed to flush all on-disk errors, retaining unsent errors for later.");
        }
    }

    private void flushErrorReport(File errorFile, ErrorReportApiClient errorReportApiClient) {
        block4: {
            try {
                Report report = new Report(this.config.getApiKey(), errorFile);
                errorReportApiClient.postReport(this.config.getEndpoint(), report, this.config.getErrorApiHeaders());
                Logger.info("Deleting sent error file " + errorFile.getName());
                if (!errorFile.delete()) {
                    errorFile.deleteOnExit();
                }
            }
            catch (NetworkException e) {
                Logger.warn("Could not send previously saved error(s) to Bugsnag, will try again later", e);
            }
            catch (Exception e) {
                Logger.warn("Problem sending unsent error from disk", e);
                if (errorFile.delete()) break block4;
                errorFile.deleteOnExit();
            }
        }
    }

    boolean isLaunchCrashReport(File file) {
        return file.getName().endsWith("_startupcrash.json");
    }

    private List<File> findLaunchCrashReports() {
        List<File> storedFiles = this.findStoredFiles();
        ArrayList<File> launchCrashes = new ArrayList<File>();
        for (File file : storedFiles) {
            if (!this.isLaunchCrashReport(file)) continue;
            launchCrashes.add(file);
        }
        return launchCrashes;
    }

    @Override
    @NonNull
    String getFilename(Error error) {
        boolean isStartupCrash = this.isStartupCrash(AppData.getDurationMs());
        String suffix = isStartupCrash ? STARTUP_CRASH : "";
        return String.format(Locale.US, "%s%d_%s%s.json", this.storeDirectory, System.currentTimeMillis(), UUID.randomUUID().toString(), suffix);
    }

    boolean isStartupCrash(long durationMs) {
        return durationMs < this.config.getLaunchCrashThresholdMs();
    }
}

