/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;

public class JsonStream
extends JsonWriter {
    private final Writer out;

    public JsonStream(Writer out) {
        super(out);
        this.setSerializeNulls(false);
        this.out = out;
    }

    @Override
    @NonNull
    public JsonStream name(@Nullable String name) throws IOException {
        super.name(name);
        return this;
    }

    public void value(@Nullable Streamable streamable) throws IOException {
        if (streamable == null) {
            this.nullValue();
            return;
        }
        streamable.toStream(this);
    }

    public void value(@NonNull File file) throws IOException {
        super.flush();
        this.beforeValue(false);
        FileReader input = null;
        try {
            input = new FileReader(file);
            IOUtils.copy(input, this.out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        this.out.flush();
    }

    public static interface Streamable {
        public void toStream(@NonNull JsonStream var1) throws IOException;
    }
}

