/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

abstract class FileStore<T extends JsonStream.Streamable> {
    @NonNull
    protected final Configuration config;
    @Nullable
    final String storeDirectory;
    private final int maxStoreCount;
    private final Comparator<File> comparator;

    FileStore(@NonNull Configuration config, @NonNull Context appContext, String folder, int maxStoreCount, Comparator<File> comparator) {
        String path;
        this.config = config;
        this.maxStoreCount = maxStoreCount;
        this.comparator = comparator;
        try {
            path = appContext.getCacheDir().getAbsolutePath() + folder;
            File outFile = new File(path);
            outFile.mkdirs();
            if (!outFile.exists()) {
                Logger.warn("Could not prepare file storage directory");
                path = null;
            }
        }
        catch (Exception e) {
            Logger.warn("Could not prepare file storage directory", e);
            path = null;
        }
        this.storeDirectory = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    String write(@NonNull T streamable) {
        String string;
        File[] files;
        if (this.storeDirectory == null) {
            return null;
        }
        File exceptionDir = new File(this.storeDirectory);
        if (exceptionDir.isDirectory() && (files = exceptionDir.listFiles()) != null && files.length >= this.maxStoreCount) {
            Arrays.sort(files, this.comparator);
            Logger.warn(String.format("Discarding oldest error as stored error limit reached (%s)", files[0].getPath()));
            if (!files[0].delete()) {
                files[0].deleteOnExit();
            }
        }
        String filename = this.getFilename(streamable);
        FileWriter out = null;
        try {
            out = new FileWriter(filename);
            JsonStream stream = new JsonStream(out);
            stream.value((JsonStream.Streamable)streamable);
            stream.close();
            Logger.info(String.format("Saved unsent payload to disk (%s) ", filename));
            string = filename;
        }
        catch (Exception e) {
            try {
                Logger.warn(String.format("Couldn't save unsent payload to disk (%s) ", filename), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
            return null;
        }
        IOUtils.closeQuietly(out);
        return string;
    }

    @NonNull
    abstract String getFilename(T var1);

    List<File> findStoredFiles() {
        File[] values;
        File dir;
        ArrayList<File> files = new ArrayList<File>();
        if (this.storeDirectory != null && (dir = new File(this.storeDirectory)).exists() && dir.isDirectory() && (values = dir.listFiles()) != null) {
            files.addAll(Arrays.asList(values));
        }
        return files;
    }
}

