/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class Breadcrumbs
implements JsonStream.Streamable {
    private static final int DEFAULT_MAX_SIZE = 32;
    private static final int MAX_PAYLOAD_SIZE = 4096;
    final Queue<Breadcrumb> store = new ConcurrentLinkedQueue<Breadcrumb>();
    private int maxSize = 32;

    Breadcrumbs() {
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Breadcrumb breadcrumb : this.store) {
            breadcrumb.toStream(writer);
        }
        writer.endArray();
    }

    void add(@NonNull String message) {
        this.addToStore(new Breadcrumb(message));
    }

    void add(@NonNull String name, @NonNull BreadcrumbType type, @NonNull Map<String, String> metadata) {
        this.addToStore(new Breadcrumb(name, type, metadata));
    }

    void clear() {
        this.store.clear();
    }

    void setSize(int size) {
        if (size < 0) {
            Logger.warn("Ignoring invalid breadcrumb capacity. Must be >= 0.");
            return;
        }
        this.maxSize = size;
        while (this.store.size() > size) {
            this.store.poll();
        }
    }

    private void addToStore(@NonNull Breadcrumb breadcrumb) {
        try {
            if (breadcrumb.payloadSize() > 4096) {
                Logger.warn("Dropping breadcrumb because payload exceeds 4KB limit");
                return;
            }
            this.store.add(breadcrumb);
            if (this.store.size() > this.maxSize) {
                this.store.poll();
            }
        }
        catch (IOException ex) {
            Logger.warn("Dropping breadcrumb because it could not be serialized", ex);
        }
    }

    private static class Breadcrumb
    implements JsonStream.Streamable {
        private static final int MAX_MESSAGE_LENGTH = 140;
        private static final String DEFAULT_NAME = "manual";
        private static final String MESSAGE_METAKEY = "message";
        private final String TIMESTAMP_KEY = "timestamp";
        private final String NAME_KEY = "name";
        private final String METADATA_KEY = "metaData";
        private final String TYPE_KEY = "type";
        final String timestamp = DateUtils.toISO8601(new Date());
        @NonNull
        final String name;
        @NonNull
        final BreadcrumbType type;
        @NonNull
        final Map<String, String> metadata;

        Breadcrumb(@NonNull String message) {
            this.type = BreadcrumbType.MANUAL;
            this.metadata = Collections.singletonMap(MESSAGE_METAKEY, message.substring(0, Math.min(message.length(), 140)));
            this.name = DEFAULT_NAME;
        }

        Breadcrumb(@NonNull String name, @NonNull BreadcrumbType type, @NonNull Map<String, String> metadata) {
            this.type = type;
            this.metadata = metadata;
            this.name = name;
        }

        @Override
        public void toStream(@NonNull JsonStream writer) throws IOException {
            writer.beginObject();
            writer.name("timestamp").value(this.timestamp);
            writer.name("name").value(this.name);
            writer.name("type").value(this.type.toString());
            writer.name("metaData");
            writer.beginObject();
            ArrayList<String> keys = new ArrayList<String>(this.metadata.keySet());
            Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
            for (String key : keys) {
                writer.name(key).value(this.metadata.get(key));
            }
            writer.endObject();
            writer.endObject();
        }

        public int payloadSize() throws IOException {
            StringWriter writer = new StringWriter();
            JsonStream jsonStream = new JsonStream(writer);
            this.toStream(jsonStream);
            return writer.toString().length();
        }
    }
}

