/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;

class AppDataSummary
implements JsonStream.Streamable {
    static final String RELEASE_STAGE_DEVELOPMENT = "development";
    static final String RELEASE_STAGE_PRODUCTION = "production";
    @NonNull
    protected final Configuration config;
    @Nullable
    protected final Integer versionCode;
    @Nullable
    protected final String versionName;
    @NonNull
    private final String guessedReleaseStage;
    @Nullable
    private String notifierType = "android";
    @Nullable
    private String codeBundleId;

    AppDataSummary(@NonNull Context appContext, @NonNull Configuration config) {
        this.versionCode = AppDataSummary.getVersionCode(appContext);
        this.versionName = AppDataSummary.getVersionName(appContext);
        this.guessedReleaseStage = AppDataSummary.guessReleaseStage(appContext);
        this.config = config;
        this.codeBundleId = config.getCodeBundleId();
        String configType = config.getNotifierType();
        if (configType != null) {
            this.notifierType = configType;
        }
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        this.serialiseMinimalAppData(writer);
        writer.endObject();
    }

    void serialiseMinimalAppData(@NonNull JsonStream writer) throws IOException {
        writer.name("type").value(this.notifierType).name("releaseStage").value(this.getReleaseStage()).name("version").value(this.getAppVersion()).name("versionCode").value(this.versionCode).name("codeBundleId").value(this.codeBundleId);
    }

    @NonNull
    String getReleaseStage() {
        if (this.config.getReleaseStage() != null) {
            return this.config.getReleaseStage();
        }
        return this.guessedReleaseStage;
    }

    @Nullable
    String getAppVersion() {
        if (this.config.getAppVersion() != null) {
            return this.config.getAppVersion();
        }
        return this.versionName;
    }

    @Nullable
    private static Integer getVersionCode(@NonNull Context appContext) {
        try {
            return appContext.getPackageManager().getPackageInfo((String)appContext.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get versionCode");
            return null;
        }
    }

    @Nullable
    private static String getVersionName(@NonNull Context appContext) {
        try {
            return appContext.getPackageManager().getPackageInfo((String)appContext.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get versionName");
            return null;
        }
    }

    @NonNull
    static String guessReleaseStage(@NonNull Context appContext) {
        try {
            int appFlags = appContext.getPackageManager().getApplicationInfo((String)appContext.getPackageName(), (int)0).flags;
            if ((appFlags & 2) != 0) {
                return RELEASE_STAGE_DEVELOPMENT;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get releaseStage");
        }
        return RELEASE_STAGE_PRODUCTION;
    }
}

