/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.User;
import java.io.IOException;
import java.util.Date;

class Session
implements JsonStream.Streamable {
    private final String id;
    private final Date startedAt;
    private final User user;
    private int unhandledCount;
    private int handledCount;
    private transient boolean autoCaptured;

    public Session(String id, Date startedAt, User user) {
        this.id = id;
        this.startedAt = new Date(startedAt.getTime());
        this.user = user;
    }

    String getId() {
        return this.id;
    }

    Date getStartedAt() {
        return new Date(this.startedAt.getTime());
    }

    User getUser() {
        return this.user;
    }

    synchronized int getUnhandledCount() {
        return this.unhandledCount;
    }

    synchronized int getHandledCount() {
        return this.handledCount;
    }

    synchronized void incrementHandledErrCount() {
        ++this.handledCount;
    }

    synchronized void incrementUnhandledErrCount() {
        ++this.unhandledCount;
    }

    boolean isAutoCaptured() {
        return this.autoCaptured;
    }

    void setAutoCaptured(boolean autoCaptured) {
        this.autoCaptured = autoCaptured;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject().name("id").value(this.id).name("startedAt").value(DateUtils.toISO8601(this.startedAt));
        if (this.user != null) {
            writer.name("user").value(this.user);
        }
        writer.endObject();
    }
}

