/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class AppNotRespondingMonitor {
    private static final int CHECK_INTERVAL_MS = 5;
    private final ByteBuffer sentinelBuffer;
    private final Handler threadHandler;
    private final Delegate delegate;
    private static final char anrIndicator = 'a';
    private final Runnable checker = new Runnable(){

        @Override
        public void run() {
            try {
                ByteBuffer buffer = AppNotRespondingMonitor.this.getSentinelBuffer();
                char indicator = buffer.getChar(0);
                if (indicator == 'a') {
                    AppNotRespondingMonitor.this.getDelegate().onAppNotResponding(Looper.getMainLooper().getThread());
                    buffer.putChar(0, '\u0000');
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            finally {
                AppNotRespondingMonitor.this.getHandler().postDelayed((Runnable)this, 5L);
            }
        }
    };

    AppNotRespondingMonitor(@NonNull Delegate delegate) {
        this.sentinelBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        HandlerThread watchdogHandlerThread = new HandlerThread("bugsnag-anr-watchdog");
        watchdogHandlerThread.start();
        this.threadHandler = new Handler(watchdogHandlerThread.getLooper());
        this.delegate = delegate;
    }

    void start() {
        this.threadHandler.postDelayed(this.checker, 5L);
    }

    @NonNull
    Handler getHandler() {
        return this.threadHandler;
    }

    @NonNull
    Delegate getDelegate() {
        return this.delegate;
    }

    @NonNull
    ByteBuffer getSentinelBuffer() {
        return this.sentinelBuffer;
    }

    static interface Delegate {
        public void onAppNotResponding(Thread var1);
    }
}

