/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.User;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class Session
implements JsonStream.Streamable {
    private final String id;
    private final Date startedAt;
    private final User user;
    private final AtomicBoolean autoCaptured;
    private AtomicInteger unhandledCount = new AtomicInteger();
    private AtomicInteger handledCount = new AtomicInteger();
    private AtomicBoolean tracked = new AtomicBoolean(false);
    final AtomicBoolean isStopped = new AtomicBoolean(false);

    static Session copySession(Session session) {
        Session copy = new Session(session.id, session.startedAt, session.user, session.unhandledCount.get(), session.handledCount.get());
        copy.tracked.set(session.tracked.get());
        copy.autoCaptured.set(session.isAutoCaptured());
        return copy;
    }

    public Session(String id, Date startedAt, User user, boolean autoCaptured) {
        this.id = id;
        this.startedAt = new Date(startedAt.getTime());
        this.user = user;
        this.autoCaptured = new AtomicBoolean(autoCaptured);
    }

    Session(String id, Date startedAt, User user, int unhandledCount, int handledCount) {
        this.id = id;
        this.startedAt = new Date(startedAt.getTime());
        this.user = user;
        this.autoCaptured = new AtomicBoolean(false);
        this.unhandledCount = new AtomicInteger(unhandledCount);
        this.handledCount = new AtomicInteger(handledCount);
        this.tracked = new AtomicBoolean(true);
    }

    String getId() {
        return this.id;
    }

    Date getStartedAt() {
        return new Date(this.startedAt.getTime());
    }

    User getUser() {
        return this.user;
    }

    int getUnhandledCount() {
        return this.unhandledCount.intValue();
    }

    int getHandledCount() {
        return this.handledCount.intValue();
    }

    Session incrementHandledAndCopy() {
        this.handledCount.incrementAndGet();
        return Session.copySession(this);
    }

    Session incrementUnhandledAndCopy() {
        this.unhandledCount.incrementAndGet();
        return Session.copySession(this);
    }

    AtomicBoolean isTracked() {
        return this.tracked;
    }

    boolean isAutoCaptured() {
        return this.autoCaptured.get();
    }

    void setAutoCaptured(boolean autoCaptured) {
        this.autoCaptured.set(autoCaptured);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject().name("id").value(this.id).name("startedAt").value(DateUtils.toIso8601(this.startedAt));
        if (this.user != null) {
            writer.name("user").value(this.user);
        }
        writer.endObject();
    }
}

