/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Severity;
import java.io.IOException;

final class HandledState
implements JsonStream.Streamable {
    static final String REASON_UNHANDLED_EXCEPTION = "unhandledException";
    static final String REASON_STRICT_MODE = "strictMode";
    static final String REASON_HANDLED_EXCEPTION = "handledException";
    static final String REASON_USER_SPECIFIED = "userSpecifiedSeverity";
    static final String REASON_CALLBACK_SPECIFIED = "userCallbackSetSeverity";
    static final String REASON_PROMISE_REJECTION = "unhandledPromiseRejection";
    static final String REASON_SIGNAL = "signal";
    static final String REASON_LOG = "log";
    static final String REASON_ANR = "anrError";
    private final String severityReasonType;
    @Nullable
    private final String attributeValue;
    private final Severity defaultSeverity;
    private Severity currentSeverity;
    private final boolean unhandled;

    static HandledState newInstance(String severityReasonType) {
        return HandledState.newInstance(severityReasonType, null, null);
    }

    static HandledState newInstance(String severityReasonType, @Nullable Severity severity, @Nullable String attributeValue) {
        if (severityReasonType.equals(REASON_STRICT_MODE) && TextUtils.isEmpty((CharSequence)attributeValue)) {
            throw new IllegalArgumentException("No reason supplied for strictmode");
        }
        if (!(severityReasonType.equals(REASON_STRICT_MODE) || severityReasonType.equals(REASON_LOG) || TextUtils.isEmpty((CharSequence)attributeValue))) {
            throw new IllegalArgumentException("attributeValue should not be supplied");
        }
        switch (severityReasonType) {
            case "unhandledException": {
                return new HandledState(severityReasonType, Severity.ERROR, true, null);
            }
            case "strictMode": {
                return new HandledState(severityReasonType, Severity.WARNING, true, attributeValue);
            }
            case "handledException": {
                return new HandledState(severityReasonType, Severity.WARNING, false, null);
            }
            case "userSpecifiedSeverity": {
                return new HandledState(severityReasonType, severity, false, null);
            }
            case "userCallbackSetSeverity": {
                return new HandledState(severityReasonType, severity, false, null);
            }
            case "unhandledPromiseRejection": {
                return new HandledState(severityReasonType, Severity.ERROR, true, null);
            }
            case "log": {
                return new HandledState(severityReasonType, severity, false, attributeValue);
            }
            case "anrError": {
                return new HandledState(severityReasonType, Severity.ERROR, true, null);
            }
        }
        String msg = String.format("Invalid argument '%s' for severityReason", severityReasonType);
        throw new IllegalArgumentException(msg);
    }

    HandledState(String severityReasonType, Severity currentSeverity, boolean unhandled, @Nullable String attributeValue) {
        this.severityReasonType = severityReasonType;
        this.defaultSeverity = currentSeverity;
        this.unhandled = unhandled;
        this.attributeValue = attributeValue;
        this.currentSeverity = currentSeverity;
    }

    String calculateSeverityReasonType() {
        return this.defaultSeverity == this.currentSeverity ? this.severityReasonType : REASON_CALLBACK_SPECIFIED;
    }

    Severity getCurrentSeverity() {
        return this.currentSeverity;
    }

    boolean isUnhandled() {
        return this.unhandled;
    }

    @Nullable
    String getAttributeValue() {
        return this.attributeValue;
    }

    void setCurrentSeverity(Severity severity) {
        this.currentSeverity = severity;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject().name("type").value(this.calculateSeverityReasonType());
        if (this.attributeValue != null) {
            String attributeKey = null;
            switch (this.severityReasonType) {
                case "log": {
                    attributeKey = "level";
                    break;
                }
                case "strictMode": {
                    attributeKey = "violationType";
                    break;
                }
            }
            if (attributeKey != null) {
                writer.name("attributes").beginObject().name(attributeKey).value(this.attributeValue).endObject();
            }
        }
        writer.endObject();
    }
}

