/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import com.bugsnag.android.ForegroundDetector;

final class BlockedThreadDetector {
    static final int MIN_CHECK_INTERVAL_MS = 1000;
    final Looper looper;
    final long checkIntervalMs;
    final long blockedThresholdMs;
    final Handler uiHandler;
    final Handler watchdogHandler;
    final Delegate delegate;
    final ForegroundDetector foregroundDetector;
    volatile long lastUpdateMs;
    volatile boolean isAlreadyBlocked = false;
    final Runnable livenessCheck = new Runnable(){

        @Override
        public void run() {
            BlockedThreadDetector.this.updateLivenessTimestamp();
            BlockedThreadDetector.this.uiHandler.postDelayed((Runnable)this, BlockedThreadDetector.this.checkIntervalMs);
        }
    };
    final Runnable watchdogCheck = new Runnable(){

        @Override
        public void run() {
            BlockedThreadDetector.this.checkIfThreadBlocked();
            BlockedThreadDetector.this.watchdogHandler.postDelayed((Runnable)this, BlockedThreadDetector.this.calculateNextCheckIn());
        }
    };

    BlockedThreadDetector(long blockedThresholdMs, Looper looper, ForegroundDetector foregroundDetector, Delegate delegate) {
        this(blockedThresholdMs, 1000L, looper, foregroundDetector, delegate);
    }

    BlockedThreadDetector(long blockedThresholdMs, long checkIntervalMs, Looper looper, ForegroundDetector foregroundDetector, Delegate delegate) {
        if (blockedThresholdMs <= 0L || checkIntervalMs <= 0L || looper == null || delegate == null) {
            throw new IllegalArgumentException();
        }
        this.blockedThresholdMs = blockedThresholdMs;
        this.checkIntervalMs = checkIntervalMs;
        this.looper = looper;
        this.delegate = delegate;
        this.uiHandler = new Handler(looper);
        this.foregroundDetector = foregroundDetector;
        HandlerThread watchdogHandlerThread = new HandlerThread("bugsnag-anr-watchdog");
        watchdogHandlerThread.start();
        this.watchdogHandler = new Handler(watchdogHandlerThread.getLooper());
    }

    void start() {
        this.updateLivenessTimestamp();
        this.uiHandler.post(this.livenessCheck);
        this.watchdogHandler.postDelayed(this.watchdogCheck, this.calculateNextCheckIn());
    }

    void updateLivenessTimestamp() {
        this.lastUpdateMs = SystemClock.uptimeMillis();
    }

    long calculateNextCheckIn() {
        long currentUptimeMs = SystemClock.uptimeMillis();
        return Math.max(this.lastUpdateMs + this.blockedThresholdMs - currentUptimeMs, 0L);
    }

    void checkIfThreadBlocked() {
        long delta = SystemClock.uptimeMillis() - this.lastUpdateMs;
        boolean inForeground = this.foregroundDetector.isInForeground();
        if (inForeground && delta > this.blockedThresholdMs) {
            if (!this.isAlreadyBlocked) {
                this.delegate.onThreadBlocked(this.looper.getThread());
            }
            this.isAlreadyBlocked = true;
        } else {
            this.isAlreadyBlocked = false;
        }
    }

    static interface Delegate {
        public void onThreadBlocked(Thread var1);
    }
}

