/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Session;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Error
implements JsonStream.Streamable {
    @NonNull
    private Map<String, Object> appData = new HashMap<String, Object>();
    @NonNull
    private Map<String, Object> deviceData = new HashMap<String, Object>();
    @NonNull
    private User user = new User();
    @Nullable
    private Severity severity;
    @NonNull
    private MetaData metaData = new MetaData();
    @Nullable
    private String groupingHash;
    @Nullable
    private String context;
    @NonNull
    final Configuration config;
    private final String[] projectPackages;
    private final Exceptions exceptions;
    private Breadcrumbs breadcrumbs;
    private final Throwable exception;
    private final HandledState handledState;
    private final Session session;
    private final ThreadState threadState;

    Error(@NonNull Configuration config, @NonNull Throwable exception, HandledState handledState, @NonNull Severity severity, Session session, ThreadState threadState) {
        this.threadState = threadState;
        this.config = config;
        this.exception = exception;
        this.handledState = handledState;
        this.severity = severity;
        this.session = session;
        this.projectPackages = config.getProjectPackages();
        this.exceptions = new Exceptions(config, exception);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        MetaData mergedMetaData = MetaData.merge(this.config.getMetaData(), this.metaData);
        writer.beginObject();
        writer.name("context").value(this.context);
        writer.name("metaData").value(mergedMetaData);
        writer.name("severity").value(this.severity);
        writer.name("severityReason").value(this.handledState);
        writer.name("unhandled").value(this.handledState.isUnhandled());
        if (this.projectPackages != null) {
            writer.name("projectPackages").beginArray();
            for (String projectPackage : this.projectPackages) {
                writer.value(projectPackage);
            }
            writer.endArray();
        }
        writer.name("exceptions").value(this.exceptions);
        writer.name("user").value(this.user);
        writer.name("app").value(this.appData);
        writer.name("device").value(this.deviceData);
        writer.name("breadcrumbs").value(this.breadcrumbs);
        writer.name("groupingHash").value(this.groupingHash);
        if (this.config.getSendThreads()) {
            writer.name("threads").value(this.threadState);
        }
        if (this.session != null) {
            writer.name("session").beginObject();
            writer.name("id").value(this.session.getId());
            writer.name("startedAt").value(DateUtils.toIso8601(this.session.getStartedAt()));
            writer.name("events").beginObject();
            writer.name("handled").value(this.session.getHandledCount());
            writer.name("unhandled").value(this.session.getUnhandledCount());
            writer.endObject();
            writer.endObject();
        }
        writer.endObject();
    }

    public void setContext(@Nullable String context) {
        this.context = context;
    }

    @Nullable
    public String getContext() {
        return this.context;
    }

    public void setGroupingHash(@Nullable String groupingHash) {
        this.groupingHash = groupingHash;
    }

    @Nullable
    public String getGroupingHash() {
        return this.groupingHash;
    }

    public void setSeverity(@Nullable Severity severity) {
        if (severity != null) {
            this.severity = severity;
            this.handledState.setCurrentSeverity(severity);
        }
    }

    @Nullable
    public Severity getSeverity() {
        return this.severity;
    }

    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.user = new User(id, email, name);
    }

    void setUser(@NonNull User user) {
        this.user = user;
    }

    @NonNull
    public User getUser() {
        return this.user;
    }

    public void setUserId(@Nullable String id) {
        this.user = new User(this.user);
        this.user.setId(id);
    }

    public void setUserEmail(@Nullable String email) {
        this.user = new User(this.user);
        this.user.setEmail(email);
    }

    public void setUserName(@Nullable String name) {
        this.user = new User(this.user);
        this.user.setName(name);
    }

    public void addToTab(@NonNull String tabName, @NonNull String key, @Nullable Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public void clearTab(@NonNull String tabName) {
        this.metaData.clearTab(tabName);
    }

    @NonNull
    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(@NonNull MetaData metaData) {
        this.metaData = metaData == null ? new MetaData() : metaData;
    }

    @NonNull
    public String getExceptionName() {
        if (this.exception instanceof BugsnagException) {
            return ((BugsnagException)this.exception).getName();
        }
        return this.exception.getClass().getName();
    }

    @NonNull
    public String getExceptionMessage() {
        String localizedMessage = this.exception.getLocalizedMessage();
        return localizedMessage != null ? localizedMessage : "";
    }

    @NonNull
    public Throwable getException() {
        return this.exception;
    }

    public void setDeviceId(@Nullable String id) {
        this.deviceData.put("id", id);
    }

    @NonNull
    Map<String, Object> getAppData() {
        return this.appData;
    }

    @NonNull
    public Map<String, Object> getDeviceData() {
        return this.deviceData;
    }

    void setAppData(@NonNull Map<String, Object> appData) {
        this.appData = appData;
    }

    void setDeviceData(@NonNull Map<String, Object> deviceData) {
        this.deviceData = deviceData;
    }

    void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    boolean shouldIgnoreClass() {
        return this.config.shouldIgnoreClass(this.getExceptionName());
    }

    HandledState getHandledState() {
        return this.handledState;
    }

    Exceptions getExceptions() {
        return this.exceptions;
    }

    Session getSession() {
        return this.session;
    }

    static class Builder {
        private final Configuration config;
        private final Throwable exception;
        private final Session session;
        private final ThreadState threadState;
        private Severity severity = Severity.WARNING;
        private MetaData metaData;
        private String attributeValue;
        private String severityReasonType;

        Builder(@NonNull Configuration config, @NonNull Throwable exception, @Nullable Session session, @NonNull Thread thread, boolean unhandled) {
            Throwable exc = unhandled ? exception : null;
            this.threadState = new ThreadState(config, thread, Thread.getAllStackTraces(), exc);
            this.config = config;
            this.exception = exception;
            this.severityReasonType = "userSpecifiedSeverity";
            this.session = session != null && !config.getAutoCaptureSessions() && session.isAutoCaptured() ? null : session;
        }

        Builder(@NonNull Configuration config, @NonNull String name, @NonNull String message, @NonNull StackTraceElement[] frames, Session session, Thread thread) {
            this(config, new BugsnagException(name, message, frames), session, thread, false);
        }

        Builder severityReasonType(String severityReasonType) {
            this.severityReasonType = severityReasonType;
            return this;
        }

        Builder attributeValue(String value) {
            this.attributeValue = value;
            return this;
        }

        Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        Error build() {
            HandledState handledState = HandledState.newInstance(this.severityReasonType, this.severity, this.attributeValue);
            Error error = new Error(this.config, this.exception, handledState, this.severity, this.session, this.threadState);
            if (this.metaData != null) {
                error.setMetaData(this.metaData);
            }
            return error;
        }
    }
}

