/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Async;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Report;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;

class ErrorStore {
    private static final String UNSENT_ERROR_PATH = "/bugsnag-errors/";
    private static final String STARTUP_CRASH = "_startupcrash";
    private static final int MAX_STORED_ERRORS = 100;
    static final Comparator<File> ERROR_REPORT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            String rhsName = rhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            return lhsName.compareTo(rhsName);
        }
    };
    @NonNull
    private final Configuration config;
    @Nullable
    final String path;

    ErrorStore(@NonNull Configuration config, @NonNull Context appContext) {
        String path;
        this.config = config;
        try {
            path = appContext.getCacheDir().getAbsolutePath() + UNSENT_ERROR_PATH;
            File outFile = new File(path);
            outFile.mkdirs();
            if (!outFile.exists()) {
                Logger.warn("Could not prepare error storage directory");
                path = null;
            }
        }
        catch (Exception e) {
            Logger.warn("Could not prepare error storage directory", e);
            path = null;
        }
        this.path = path;
    }

    void flushOnLaunch(ErrorReportApiClient errorReportApiClient) {
        List<File> crashReports = this.findLaunchCrashReports();
        if (crashReports.isEmpty() && this.config.getLaunchCrashThresholdMs() > 0L) {
            this.flushAsync(errorReportApiClient);
        } else {
            StrictMode.ThreadPolicy originalThreadPolicy = StrictMode.getThreadPolicy();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)StrictMode.ThreadPolicy.LAX);
            for (File crashReport : crashReports) {
                this.flushErrorReport(crashReport, errorReportApiClient);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalThreadPolicy);
        }
    }

    void flushAsync(final ErrorReportApiClient errorReportApiClient) {
        if (this.path == null) {
            return;
        }
        try {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    File exceptionDir = new File(ErrorStore.this.path);
                    if (!exceptionDir.exists() || !exceptionDir.isDirectory()) {
                        return;
                    }
                    File[] errorFiles = exceptionDir.listFiles();
                    if (errorFiles != null && errorFiles.length > 0) {
                        Logger.info(String.format(Locale.US, "Sending %d saved error(s) to Bugsnag", errorFiles.length));
                        for (File errorFile : errorFiles) {
                            ErrorStore.this.flushErrorReport(errorFile, errorReportApiClient);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Logger.warn("Failed to flush all on-disk errors, retaining unsent errors for later.");
        }
    }

    private void flushErrorReport(File errorFile, ErrorReportApiClient errorReportApiClient) {
        block4: {
            try {
                Report report = new Report(this.config.getApiKey(), errorFile);
                errorReportApiClient.postReport(this.config.getEndpoint(), report);
                Logger.info("Deleting sent error file " + errorFile.getName());
                if (!errorFile.delete()) {
                    errorFile.deleteOnExit();
                }
            }
            catch (ErrorReportApiClient.NetworkException e) {
                Logger.warn("Could not send previously saved error(s) to Bugsnag, will try again later", e);
            }
            catch (Exception e) {
                Logger.warn("Problem sending unsent error from disk", e);
                if (errorFile.delete()) break block4;
                errorFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    String write(@NonNull Error error) {
        String string;
        MetaData metaData;
        File[] files;
        if (this.path == null) {
            return null;
        }
        File exceptionDir = new File(this.path);
        if (exceptionDir.isDirectory() && (files = exceptionDir.listFiles()) != null && files.length >= 100) {
            Arrays.sort(files, ERROR_REPORT_COMPARATOR);
            Logger.warn(String.format("Discarding oldest error as stored error limit reached (%s)", files[0].getPath()));
            if (!files[0].delete()) {
                files[0].deleteOnExit();
            }
        }
        boolean isStartupCrash = (metaData = error.getMetaData()) != null && metaData.getTab("CrashOnLaunch").containsKey("Duration (ms)");
        String suffix = isStartupCrash ? STARTUP_CRASH : "";
        String filename = String.format(Locale.US, "%s%d%s.json", this.path, System.currentTimeMillis(), suffix);
        FileWriter out = null;
        try {
            out = new FileWriter(filename);
            JsonStream stream = new JsonStream(out);
            stream.value(error);
            stream.close();
            Logger.info(String.format("Saved unsent error to disk (%s) ", filename));
            string = filename;
        }
        catch (Exception e) {
            try {
                Logger.warn(String.format("Couldn't save unsent error to disk (%s) ", filename), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
            return null;
        }
        IOUtils.closeQuietly(out);
        return string;
    }

    boolean isLaunchCrashReport(File file) {
        String name = file.getName();
        return name.matches("[0-9]+_startupcrash\\.json");
    }

    private List<File> findLaunchCrashReports() {
        File[] files;
        if (this.path == null) {
            return Collections.emptyList();
        }
        File exceptionDir = new File(this.path);
        ArrayList<File> launchCrashes = new ArrayList<File>();
        if (exceptionDir.isDirectory() && (files = exceptionDir.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (!this.isLaunchCrashReport(file)) continue;
                launchCrashes.add(file);
            }
        }
        return launchCrashes;
    }
}

