/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;

class JsonStream
extends JsonWriter {
    private final Writer out;

    JsonStream(Writer out) {
        super(out);
        this.setSerializeNulls(false);
        this.out = out;
    }

    @Override
    public JsonStream name(@NonNull String name) throws IOException {
        super.name(name);
        return this;
    }

    public void value(Streamable streamable) throws IOException {
        if (streamable == null) {
            this.nullValue();
            return;
        }
        streamable.toStream(this);
    }

    public void value(@NonNull File file) throws IOException {
        super.flush();
        FileReader input = null;
        try {
            input = new FileReader(file);
            IOUtils.copy(input, this.out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        this.out.flush();
    }

    static interface Streamable {
        public void toStream(@NonNull JsonStream var1) throws IOException;
    }
}

