/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

class ThreadState
implements JsonStream.Streamable {
    final Configuration config;

    ThreadState(Configuration config) {
        this.config = config;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        long currentId = Thread.currentThread().getId();
        Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
        Object[] keys = liveThreads.keySet().toArray();
        Arrays.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return Long.valueOf(((Thread)a).getId()).compareTo(((Thread)b).getId());
            }
        });
        writer.beginArray();
        for (int i = 0; i < keys.length; ++i) {
            Thread thread = (Thread)keys[i];
            if (thread.getId() == currentId) continue;
            StackTraceElement[] stacktrace = liveThreads.get(thread);
            writer.beginObject();
            writer.name("id").value(thread.getId());
            writer.name("name").value(thread.getName());
            writer.name("stacktrace").value(new Stacktrace(this.config, stacktrace));
            writer.endObject();
        }
        writer.endArray();
    }
}

