/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;

class JsonStream
extends JsonWriter {
    private final Writer out;

    JsonStream(Writer out) {
        super(out);
        this.out = out;
    }

    @Override
    public JsonStream name(@NonNull String name) throws IOException {
        super.name(name);
        return this;
    }

    public void value(@NonNull Boolean value) throws IOException {
        if (value == null) {
            this.nullValue();
            return;
        }
        super.value(value);
    }

    @Override
    public JsonWriter value(@NonNull String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return super.value(value);
    }

    @Override
    public JsonWriter value(@NonNull Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return super.value(value);
    }

    public void value(@NonNull Streamable streamable) throws IOException {
        streamable.toStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void value(@NonNull File file) throws IOException {
        super.flush();
        FileReader input = null;
        try {
            input = new FileReader(file);
            IOUtils.copy(input, this.out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        this.out.flush();
    }

    static interface Streamable {
        public void toStream(@NonNull JsonStream var1) throws IOException;
    }
}

