/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;

class ExceptionChain
implements JsonStream.Streamable {
    private Configuration config;
    private Throwable exception;

    ExceptionChain(Configuration config, Throwable exception) {
        this.config = config;
        this.exception = exception;
    }

    @Override
    public void toStream(JsonStream writer) {
        writer.beginArray();
        for (Throwable currentEx = this.exception; currentEx != null; currentEx = currentEx.getCause()) {
            Stacktrace stacktrace = new Stacktrace(this.config, currentEx.getStackTrace());
            writer.beginObject();
            writer.name("errorClass").value(currentEx.getClass().getName());
            writer.name("message").value(currentEx.getLocalizedMessage());
            writer.name("stacktrace").value(stacktrace);
            writer.endObject();
        }
        writer.endArray();
    }
}

