/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.ExceptionChain;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;

public class Error
implements JsonStream.Streamable {
    private static final String PAYLOAD_VERSION = "2";
    private Configuration config;
    private AppData appData;
    private DeviceData deviceData;
    private AppState appState;
    private DeviceState deviceState;
    private User user;
    private Throwable exception;
    private Severity severity = Severity.WARNING;
    private MetaData metaData = new MetaData();
    private String groupingHash;
    private String context;

    Error(Configuration config, Throwable exception) {
        this.config = config;
        this.exception = exception;
    }

    @Override
    public void toStream(JsonStream writer) {
        MetaData mergedMetaData = MetaData.merge(this.config.metaData, this.metaData);
        mergedMetaData.setFilters(this.config.filters);
        writer.beginObject();
        writer.name("payloadVersion").value(PAYLOAD_VERSION);
        writer.name("exceptions").value(new ExceptionChain(this.config, this.exception));
        writer.name("context").value(this.getContext());
        writer.name("severity").value(this.severity);
        writer.name("metaData").value(mergedMetaData);
        if (this.user != null) {
            writer.name("user").value(this.user);
        }
        if (this.appData != null) {
            writer.name("app").value(this.appData);
        }
        if (this.appState != null) {
            writer.name("appState").value(this.appState);
        }
        if (this.deviceData != null) {
            writer.name("device").value(this.deviceData);
        }
        if (this.deviceState != null) {
            writer.name("deviceState").value(this.deviceState);
        }
        if (this.groupingHash != null) {
            writer.name("groupingHash").value(this.groupingHash);
        }
        if (this.config.sendThreads) {
            writer.name("threads").value(new ThreadState(this.config));
        }
        writer.endObject();
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.config.context != null) {
            return this.config.context;
        }
        if (this.appState != null) {
            return this.appState.getActiveScreenClass();
        }
        return null;
    }

    public void setGroupingHash(String groupingHash) {
        this.groupingHash = groupingHash;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setUser(String id, String email, String name) {
        this.user = new User(id, email, name);
    }

    public void setUserId(String id) {
        this.user = new User(this.user);
        this.user.setId(id);
    }

    public void setUserEmail(String email) {
        this.user = new User(this.user);
        this.user.setEmail(email);
    }

    public void setUserName(String name) {
        this.user = new User(this.user);
        this.user.setName(name);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public void clearTab(String tabName) {
        this.metaData.clearTab(tabName);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public String getExceptionName() {
        return this.exception.getClass().getName();
    }

    public String getExceptionMessage() {
        return this.exception.getLocalizedMessage();
    }

    void setAppData(AppData appData) {
        this.appData = appData;
    }

    void setDeviceData(DeviceData deviceData) {
        this.deviceData = deviceData;
    }

    void setAppState(AppState appState) {
        this.appState = appState;
    }

    void setDeviceState(DeviceState deviceState) {
        this.deviceState = deviceState;
    }

    void setUser(User user) {
        this.user = user;
    }

    boolean shouldIgnoreClass() {
        return this.config.shouldIgnoreClass(this.exception.getClass().getName());
    }
}

