/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.JsonStream;
import java.io.File;
import java.util.Locale;

class DeviceData
implements JsonStream.Streamable {
    private Context appContext;
    private float screenDensity;
    private float dpi;
    private String screenResolution;
    private long totalMemory;
    private boolean rooted;
    private String locale;
    private String id;

    DeviceData(Context appContext) {
        this.appContext = appContext;
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        this.totalMemory = this.getTotalMemory();
        this.rooted = this.isRooted();
        this.locale = this.getLocale();
        this.id = this.getAndroidId();
    }

    @Override
    public void toStream(JsonStream writer) {
        writer.beginObject();
        writer.name("manufacturer").value(Build.MANUFACTURER);
        writer.name("brand").value(Build.BRAND);
        writer.name("model").value(Build.MODEL);
        writer.name("screenDensity").value(Float.valueOf(this.screenDensity));
        writer.name("dpi").value(Float.valueOf(this.dpi));
        writer.name("screenResolution").value(this.screenResolution);
        writer.name("totalMemory").value(this.totalMemory);
        writer.name("osName").value("android");
        writer.name("osBuild").value(Build.DISPLAY);
        writer.name("apiLevel").value(Build.VERSION.SDK_INT);
        writer.name("jailbroken").value(this.rooted);
        writer.name("locale").value(this.locale);
        writer.name("osVersion").value(Build.VERSION.RELEASE);
        writer.name("id").value(this.id);
        writer.endObject();
    }

    public String getUserId() {
        return this.id;
    }

    private float getScreenDensity() {
        return this.appContext.getResources().getDisplayMetrics().density;
    }

    private float getScreenDensityDpi() {
        return this.appContext.getResources().getDisplayMetrics().densityDpi;
    }

    private String getScreenResolution() {
        DisplayMetrics metrics = this.appContext.getResources().getDisplayMetrics();
        return String.format("%dx%d", Math.max(metrics.widthPixels, metrics.heightPixels), Math.min(metrics.widthPixels, metrics.heightPixels));
    }

    private long getTotalMemory() {
        if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
            return Runtime.getRuntime().maxMemory();
        }
        return Runtime.getRuntime().totalMemory();
    }

    private boolean isRooted() {
        boolean hasTestKeys = Build.TAGS != null && Build.TAGS.contains("test-keys");
        boolean hasSuperUserApk = false;
        try {
            File file = new File("/system/app/Superuser.apk");
            hasSuperUserApk = file.exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasTestKeys || hasSuperUserApk;
    }

    private String getLocale() {
        return Locale.getDefault().toString();
    }

    private String getAndroidId() {
        ContentResolver cr = this.appContext.getContentResolver();
        return Settings.Secure.getString((ContentResolver)cr, (String)"android_id");
    }
}

