/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.Async;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorStore;
import com.bugsnag.android.ExceptionHandler;
import com.bugsnag.android.HttpClient;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Notification;
import com.bugsnag.android.Severity;
import com.bugsnag.android.User;

public class Client {
    private Configuration config;
    private Context appContext;
    private AppData appData;
    private DeviceData deviceData;
    private User user = new User();
    private ErrorStore errorStore;

    public Client(Context androidContext, String apiKey) {
        this(androidContext, apiKey, true);
    }

    public Client(Context androidContext, String apiKey, boolean enableExceptionHandler) {
        if (androidContext == null) {
            throw new NullPointerException("You must provide a non-null android Context");
        }
        if (apiKey == null) {
            throw new NullPointerException("You must provide a Bugsnag API key");
        }
        this.config = new Configuration(apiKey);
        this.appContext = androidContext.getApplicationContext();
        this.appData = new AppData(this.appContext, this.config);
        this.deviceData = new DeviceData(this.appContext);
        AppState.init();
        this.setProjectPackages(this.appContext.getPackageName());
        this.setUserId(this.deviceData.getUserId());
        this.errorStore = new ErrorStore(this.config, this.appContext);
        if (enableExceptionHandler) {
            this.enableExceptionHandler();
        }
        this.errorStore.flush();
    }

    public void setAppVersion(String appVersion) {
        this.config.appVersion = appVersion;
    }

    public void setContext(String context) {
        this.config.context = context;
    }

    public void setEndpoint(String endpoint) {
        this.config.endpoint = endpoint;
    }

    public void setFilters(String ... filters) {
        this.config.filters = filters;
    }

    public void setIgnoreClasses(String ... ignoreClasses) {
        this.config.ignoreClasses = ignoreClasses;
    }

    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        this.config.notifyReleaseStages = notifyReleaseStages;
    }

    public void setProjectPackages(String ... projectPackages) {
        this.config.projectPackages = projectPackages;
    }

    public void setReleaseStage(String releaseStage) {
        this.config.releaseStage = releaseStage;
    }

    public void setSendThreads(boolean sendThreads) {
        this.config.sendThreads = sendThreads;
    }

    public void setUser(String id, String email, String name) {
        this.user.setId(id);
        this.user.setEmail(email);
        this.user.setName(name);
    }

    public void setUserId(String id) {
        this.user.setId(id);
    }

    public void setUserEmail(String email) {
        this.user.setEmail(email);
    }

    public void setUserName(String name) {
        this.user.setName(name);
    }

    public void beforeNotify(BeforeNotify beforeNotify) {
        this.config.beforeNotify(beforeNotify);
    }

    public void notify(Throwable exception) {
        Error error = new Error(this.config, exception);
        this.notify(error);
    }

    public void notify(Throwable exception, Severity severity) {
        Error error = new Error(this.config, exception);
        error.setSeverity(severity);
        this.notify(error);
    }

    public void notify(Throwable exception, MetaData metaData) {
        Error error = new Error(this.config, exception);
        error.setMetaData(metaData);
        this.notify(error);
    }

    public void notify(Throwable exception, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, exception);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        this.notify(error);
    }

    public void addToTab(String tab, String key, Object value) {
        this.config.metaData.addToTab(tab, key, value);
    }

    public void clearTab(String tabName) {
        this.config.metaData.clearTab(tabName);
    }

    public MetaData getMetaData() {
        return this.config.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.config.metaData = metaData;
    }

    public void enableExceptionHandler() {
        ExceptionHandler.enable(this);
    }

    public void disableExceptionHandler() {
        ExceptionHandler.disable(this);
    }

    private void notify(final Error error) {
        if (error.shouldIgnoreClass()) {
            return;
        }
        if (!this.config.shouldNotifyForReleaseStage(this.appData.getReleaseStage())) {
            return;
        }
        error.setAppData(this.appData);
        error.setDeviceData(this.deviceData);
        error.setAppState(new AppState(this.appContext));
        error.setDeviceState(new DeviceState(this.appContext));
        error.setUser(this.user);
        if (!this.runBeforeNotifyTasks(error)) {
            Logger.info("Skipping notification - beforeNotify task returned false");
            return;
        }
        final Notification notification = new Notification(this.config);
        notification.addError(error);
        Async.run(new Runnable(){

            @Override
            public void run() {
                try {
                    int errorCount = notification.deliver();
                    Logger.info(String.format("Sent %d new error(s) to Bugsnag", errorCount));
                }
                catch (HttpClient.NetworkException e) {
                    Logger.info("Could not send error(s) to Bugsnag, saving to disk to send later");
                    Client.this.errorStore.write(error);
                }
                catch (HttpClient.BadResponseException e) {
                    Logger.info("Bad response when sending data to Bugsnag");
                }
                catch (Exception e) {
                    Logger.warn("Problem sending error to Bugsnag", e);
                }
            }
        });
    }

    private boolean runBeforeNotifyTasks(Error error) {
        for (BeforeNotify beforeNotify : this.config.beforeNotifyTasks) {
            try {
                if (beforeNotify.run(error)) continue;
                return false;
            }
            catch (Throwable ex) {
                Logger.warn("BeforeNotify threw an Exception", ex);
            }
        }
        return true;
    }
}

