/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.os.SystemClock;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.util.List;

class AppState
implements JsonStream.Streamable {
    private static Long startTime = SystemClock.elapsedRealtime();
    private Context appContext;
    private Long duration;
    private Boolean inForeground;
    private String activeScreen;
    private Long memoryUsage;
    private Boolean lowMemory;

    static void init() {
    }

    AppState(Context appContext) {
        this.appContext = appContext;
        this.duration = this.getDuration();
        this.inForeground = this.isInForeground();
        this.activeScreen = this.getActiveScreen();
        this.memoryUsage = this.getMemoryUsage();
        this.lowMemory = this.isLowMemory();
    }

    @Override
    public void toStream(JsonStream writer) {
        writer.beginObject();
        writer.name("duration").value(this.duration);
        writer.name("inForeground").value(this.inForeground);
        writer.name("activeScreen").value(this.activeScreen);
        writer.name("memoryUsage").value(this.memoryUsage);
        writer.name("lowMemory").value(this.lowMemory);
        writer.endObject();
    }

    public String getActiveScreenClass() {
        if (this.activeScreen != null) {
            return this.activeScreen.substring(this.activeScreen.lastIndexOf(46) + 1);
        }
        return null;
    }

    private long getMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    private Boolean isLowMemory() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memInfo);
            return memInfo.lowMemory;
        }
        catch (Exception e) {
            Logger.warn("Could not check lowMemory status");
            return null;
        }
    }

    private String getActiveScreen() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(1);
            ActivityManager.RunningTaskInfo runningTask = (ActivityManager.RunningTaskInfo)tasks.get(0);
            return runningTask.topActivity.getClassName();
        }
        catch (Exception e) {
            Logger.warn("Could not get active screen information, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }

    private Boolean isInForeground() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(1);
            if (tasks.isEmpty()) {
                return false;
            }
            ActivityManager.RunningTaskInfo runningTask = (ActivityManager.RunningTaskInfo)tasks.get(0);
            return runningTask.topActivity.getPackageName().equalsIgnoreCase(this.appContext.getPackageName());
        }
        catch (Exception e) {
            Logger.warn("Could not check if app is in the foreground, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }

    private Long getDuration() {
        return SystemClock.elapsedRealtime() - startTime;
    }
}

