/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import com.bugsnag.android.AppData;
import com.bugsnag.android.JsonStream;

final class DeviceState
implements JsonStream.Streamable {
    private Context appContext;
    private Long freeMemory;
    private String orientation;
    private Float batteryLevel;
    private Long freeDisk;
    private Boolean charging;
    private String locationStatus;
    private String networkAccess;

    DeviceState(Context appContext) {
        DeviceState deviceState;
        this.appContext = deviceState;
        this.freeMemory = Runtime.getRuntime().maxMemory() != Long.MAX_VALUE ? Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory() : Runtime.getRuntime().freeMemory();
        deviceState = this;
        String string = null;
        switch (deviceState.appContext.getResources().getConfiguration().orientation) {
            case 1: 
            case 2: {
                string = "portrait";
            }
        }
        this.orientation = string;
        this.batteryLevel = this.getBatteryLevel();
        this.freeDisk = DeviceState.getFreeDisk();
        this.charging = this.isCharging();
        this.locationStatus = this.getLocationStatus();
        this.networkAccess = this.getNetworkAccess();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toStream(JsonStream writer) {
        void var1_1;
        writer.beginObject();
        writer.name("freeMemory").value(this.freeMemory);
        writer.name("orientation").value(this.orientation);
        writer.name("batteryLevel").value(this.batteryLevel);
        writer.name("freeDisk").value(this.freeDisk);
        writer.name("charging").value(this.charging);
        writer.name("locationStatus").value(this.locationStatus);
        writer.name("networkAccess").value(this.networkAccess);
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private Float getBatteryLevel() {
        try {
            void var1_1;
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            return Float.valueOf((float)batteryStatus.getIntExtra("level", -1) / (float)var1_1.getIntExtra("scale", -1));
        }
        catch (Exception exception) {
            AppData.warn("Could not get batteryLevel");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Long getFreeDisk() {
        try {
            void var1_1;
            void var0;
            StatFs externalStat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long externalBytesAvailable = (long)externalStat.getBlockSize() * (long)externalStat.getBlockCount();
            StatFs internalStat = new StatFs(Environment.getDataDirectory().getPath());
            long l = (long)internalStat.getBlockSize() * (long)var0.getBlockCount();
            return Math.min(l, (long)var1_1);
        }
        catch (Exception exception) {
            AppData.warn("Could not get freeDisk");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Boolean isCharging() {
        try {
            void var1_2;
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            ifilter = this.appContext.registerReceiver(null, ifilter);
            int status = ifilter.getIntExtra("status", -1);
            return status == 2 || var1_2 == 5;
        }
        catch (Exception exception) {
            AppData.warn("Could not get charging status");
            return null;
        }
    }

    private String getLocationStatus() {
        try {
            ContentResolver contentResolver = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)contentResolver, (String)"location_providers_allowed");
            if (providersAllowed != null && contentResolver.length() > 0) {
                return "allowed";
            }
            return "disallowed";
        }
        catch (Exception exception) {
            AppData.warn("Could not get locationStatus");
            return null;
        }
    }

    private String getNetworkAccess() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.appContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            if (activeNetwork != null && activeNetwork.isConnectedOrConnecting()) {
                if (activeNetwork.getType() == 1) {
                    return "wifi";
                }
                if (connectivityManager.getType() == 9) {
                    return "ethernet";
                }
                return "cellular";
            }
            return "none";
        }
        catch (Exception exception) {
            AppData.warn("Could not get network access information, we recommend granting the 'android.permission.ACCESS_NETWORK_STATE' permission");
            return null;
        }
    }
}

