/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Build;
import com.bugsnag.Error;
import com.bugsnag.MetaData;
import com.bugsnag.Metrics;
import com.bugsnag.Notification;
import com.bugsnag.android.ActivityStack;
import com.bugsnag.android.Diagnostics;
import com.bugsnag.android.Logger;
import com.bugsnag.http.BadResponseException;
import com.bugsnag.http.NetworkException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONObject;

public class Client
extends com.bugsnag.Client {
    private Logger logger;
    private Context applicationContext;
    private String cachePath;

    public Client(Context object, String object2, boolean bl) {
        super((String)object2);
        Diagnostics.startSessionTimer();
        this.logger = new Logger();
        this.setLogger(this.logger);
        this.applicationContext = object.getApplicationContext();
        this.cachePath = this.prepareCachePath();
        object2 = this;
        object = ((Client)((Object)object2)).applicationContext.getSharedPreferences("Bugsnag", 0);
        String string = object.getString("userId", null);
        if (string == null) {
            String string2 = string = UUID.randomUUID().toString();
            super.safeAsync(new Runnable((Client)((Object)object2), (SharedPreferences)object, string2){
                private /* synthetic */ SharedPreferences val$settings;
                private /* synthetic */ String val$finalUuid;
                {
                    this.val$settings = sharedPreferences;
                    this.val$finalUuid = string;
                }

                @Override
                public final void run() {
                    SharedPreferences.Editor editor = this.val$settings.edit();
                    editor.putString("userId", this.val$finalUuid);
                    editor.commit();
                }
            });
        }
        object = string;
        object2 = this;
        object2 = ((Client)((Object)object2)).applicationContext.getPackageName();
        string = this.getPackageVersion((String)object2);
        this.setNotifierName("Android Bugsnag Notifier");
        this.setNotifierVersion("2.0.8");
        this.setUserId((String)object);
        this.setOsVersion(Build.VERSION.RELEASE);
        this.setAppVersion(string);
        this.setProjectPackages(new String[]{object2});
        this.setReleaseStage(this.guessReleaseStage((String)object2));
        this.addToTab("Device", "Android Version", Build.VERSION.RELEASE);
        this.addToTab("Device", "Device Type", Build.MODEL);
        this.addToTab("Application", "Package Name", object2);
        this.addToTab("Application", "Package Version", string);
        if (bl) {
            object2 = this;
            ((Client)((Object)object2)).safeAsync(new Runnable((Client)((Object)object2), (String)object){
                private /* synthetic */ String val$userId;
                private /* synthetic */ Client this$0;
                {
                    this.this$0 = client;
                    this.val$userId = string;
                }

                @Override
                public final void run() {
                    try {
                        Metrics metrics = this.this$0.createMetrics(this.val$userId);
                        metrics.deliver();
                        return;
                    }
                    catch (NetworkException networkException) {
                        this.this$0.logger.info("Could not send metrics to Bugsnag");
                        return;
                    }
                    catch (BadResponseException badResponseException) {
                        this.this$0.logger.warn(badResponseException.getMessage());
                        return;
                    }
                }
            });
        }
        object2 = this;
        if (((Client)((Object)object2)).cachePath != null) {
            super.safeAsync(new Runnable((Client)((Object)object2)){
                private /* synthetic */ Client this$0;
                {
                    this.this$0 = client;
                }

                @Override
                public final void run() {
                    File[] fileArray = new File(this.this$0.cachePath);
                    if (fileArray.exists() && fileArray.isDirectory()) {
                        Notification notification = null;
                        for (File file : fileArray.listFiles()) {
                            try {
                                if (notification == null) {
                                    notification = this.this$0.createNotification();
                                }
                                notification.setError(file);
                                notification.deliver();
                                this.this$0.logger.debug("Deleting sent error file " + file.getName());
                                file.delete();
                            }
                            catch (NetworkException networkException) {
                                this.this$0.logger.warn("Could not send error(s) to Bugsnag, will try again later", networkException);
                            }
                            catch (Exception exception) {
                                this.this$0.logger.warn("Problem sending unsent error from disk", exception);
                                file.delete();
                            }
                        }
                    }
                }
            });
        }
        this.logger.info("Bugsnag is loaded and ready to handle exceptions");
    }

    public void notify(Throwable throwable) {
        this.notify(throwable, null);
    }

    public void notify(Throwable throwable, MetaData object) {
        try {
            if (!this.config.shouldNotify()) {
                return;
            }
            if (this.config.shouldIgnore(throwable.getClass().getName())) {
                return;
            }
            Diagnostics diagnostics = new Diagnostics(this.applicationContext);
            object = diagnostics.merge((JSONObject)object);
            throwable = this.createError(throwable, (MetaData)object);
            object = ActivityStack.getTopActivityName();
            if (object != null) {
                throwable.setContext((String)object);
            }
            this.safeAsync(new Runnable(this, (Error)throwable){
                private /* synthetic */ Error val$error;
                private /* synthetic */ Client this$0;
                {
                    this.this$0 = client;
                    this.val$error = error;
                }

                @Override
                public final void run() {
                    try {
                        Notification notification = this.this$0.createNotification(this.val$error);
                        notification.deliver();
                        return;
                    }
                    catch (NetworkException networkException) {
                        this.this$0.logger.info("Could not send error(s) to Bugsnag, saving to disk to send later");
                        Client.access$100(this.this$0, this.val$error);
                        return;
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            this.logger.warn("Error notifying Bugsnag", exception);
            return;
        }
    }

    public void setContext(Activity object) {
        object = ActivityStack.getContextName((Context)object);
        this.setContext((String)object);
    }

    private String guessReleaseStage(String string) {
        String string2 = "production";
        try {
            string = this.applicationContext.getPackageManager().getApplicationInfo(string, 0);
            boolean bl = (((ApplicationInfo)string).flags & 2) != 0;
            if (bl) {
                string2 = "development";
            }
        }
        catch (Exception exception) {
            this.logger.warn("Could not guess release stage", exception);
        }
        return string2;
    }

    private String prepareCachePath() {
        String string = null;
        try {
            string = this.applicationContext.getCacheDir().getAbsolutePath() + "/bugsnag-errors/";
            File file = new File(string);
            file.mkdirs();
            if (!file.exists()) {
                this.logger.warn("Could not prepare cache directory");
                string = null;
            }
        }
        catch (Exception exception) {
            this.logger.warn("Could not prepare cache directory", exception);
            string = null;
        }
        return string;
    }

    private String getPackageVersion(String string) {
        String string2 = null;
        try {
            string = this.applicationContext.getPackageManager().getPackageInfo(string, 0);
            string2 = ((PackageInfo)string).versionName;
        }
        catch (Exception exception) {
            this.logger.warn("Could not get package version", exception);
        }
        return string2;
    }

    private void safeAsync(Runnable runnable) {
        new AsyncTask<Void, Void, Void>(this, runnable){
            private /* synthetic */ Runnable val$delegate;
            private /* synthetic */ Client this$0;
            {
                this.this$0 = client;
                this.val$delegate = runnable;
            }

            private Void doInBackground$10299ca() {
                try {
                    this.val$delegate.run();
                }
                catch (Exception exception) {
                    this.this$0.logger.warn("Error in bugsnag", exception);
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    static /* synthetic */ void access$100(Client client, Error error) {
        if (client.cachePath == null || error == null) {
            return;
        }
        try {
            error.writeToFile(String.format("%s%d.json", client.cachePath, System.currentTimeMillis()));
            return;
        }
        catch (IOException iOException) {
            client.logger.warn("Unable to save bugsnag error", iOException);
            return;
        }
    }
}

